/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListGiftCardsRequest {
    private final Optional<String> type;
    private final Optional<String> state;
    private final Optional<Integer> limit;
    private final Optional<String> cursor;
    private final Optional<String> customerId;
    private final Map<String, Object> additionalProperties;

    private ListGiftCardsRequest(Optional<String> type, Optional<String> state, Optional<Integer> limit, Optional<String> cursor, Optional<String> customerId, Map<String, Object> additionalProperties) {
        this.type = type;
        this.state = state;
        this.limit = limit;
        this.cursor = cursor;
        this.customerId = customerId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getType() {
        if (this.type == null) {
            return Optional.empty();
        }
        return this.type;
    }

    @JsonIgnore
    public Optional<String> getState() {
        if (this.state == null) {
            return Optional.empty();
        }
        return this.state;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonIgnore
    public Optional<String> getCustomerId() {
        if (this.customerId == null) {
            return Optional.empty();
        }
        return this.customerId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="type")
    private Optional<String> _getType() {
        return this.type;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="state")
    private Optional<String> _getState() {
        return this.state;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_id")
    private Optional<String> _getCustomerId() {
        return this.customerId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListGiftCardsRequest && this.equalTo((ListGiftCardsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListGiftCardsRequest other) {
        return this.type.equals(other.type) && this.state.equals(other.state) && this.limit.equals(other.limit) && this.cursor.equals(other.cursor) && this.customerId.equals(other.customerId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.state, this.limit, this.cursor, this.customerId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> state = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<String> customerId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListGiftCardsRequest other) {
            this.type(other.getType());
            this.state(other.getState());
            this.limit(other.getLimit());
            this.cursor(other.getCursor());
            this.customerId(other.getCustomerId());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        public Builder type(Nullable<String> type) {
            this.type = type.isNull() ? null : (type.isEmpty() ? Optional.empty() : Optional.of(type.get()));
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<String> state) {
            this.state = state;
            return this;
        }

        public Builder state(String state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        public Builder state(Nullable<String> state) {
            this.state = state.isNull() ? null : (state.isEmpty() ? Optional.empty() : Optional.of(state.get()));
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public Builder cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @JsonSetter(value="customer_id", nulls=Nulls.SKIP)
        public Builder customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        public Builder customerId(Nullable<String> customerId) {
            this.customerId = customerId.isNull() ? null : (customerId.isEmpty() ? Optional.empty() : Optional.of(customerId.get()));
            return this;
        }

        public ListGiftCardsRequest build() {
            return new ListGiftCardsRequest(this.type, this.state, this.limit, this.cursor, this.customerId, this.additionalProperties);
        }
    }
}

