/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.EventTypeMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListEventTypesResponse {
    private final Optional<List<Error>> errors;
    private final Optional<List<String>> eventTypes;
    private final Optional<List<EventTypeMetadata>> metadata;
    private final Map<String, Object> additionalProperties;

    private ListEventTypesResponse(Optional<List<Error>> errors, Optional<List<String>> eventTypes, Optional<List<EventTypeMetadata>> metadata, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.eventTypes = eventTypes;
        this.metadata = metadata;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="event_types")
    public Optional<List<String>> getEventTypes() {
        return this.eventTypes;
    }

    @JsonProperty(value="metadata")
    public Optional<List<EventTypeMetadata>> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListEventTypesResponse && this.equalTo((ListEventTypesResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListEventTypesResponse other) {
        return this.errors.equals(other.errors) && this.eventTypes.equals(other.eventTypes) && this.metadata.equals(other.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.eventTypes, this.metadata);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<String>> eventTypes = Optional.empty();
        private Optional<List<EventTypeMetadata>> metadata = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListEventTypesResponse other) {
            this.errors(other.getErrors());
            this.eventTypes(other.getEventTypes());
            this.metadata(other.getMetadata());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="event_types", nulls=Nulls.SKIP)
        public Builder eventTypes(Optional<List<String>> eventTypes) {
            this.eventTypes = eventTypes;
            return this;
        }

        public Builder eventTypes(List<String> eventTypes) {
            this.eventTypes = Optional.ofNullable(eventTypes);
            return this;
        }

        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public Builder metadata(Optional<List<EventTypeMetadata>> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder metadata(List<EventTypeMetadata> metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        public ListEventTypesResponse build() {
            return new ListEventTypesResponse(this.errors, this.eventTypes, this.metadata, this.additionalProperties);
        }
    }
}

