/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DeviceCode;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListDeviceCodesResponse {
    private final Optional<List<Error>> errors;
    private final Optional<List<DeviceCode>> deviceCodes;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private ListDeviceCodesResponse(Optional<List<Error>> errors, Optional<List<DeviceCode>> deviceCodes, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.deviceCodes = deviceCodes;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="device_codes")
    public Optional<List<DeviceCode>> getDeviceCodes() {
        return this.deviceCodes;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListDeviceCodesResponse && this.equalTo((ListDeviceCodesResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListDeviceCodesResponse other) {
        return this.errors.equals(other.errors) && this.deviceCodes.equals(other.deviceCodes) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.deviceCodes, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<DeviceCode>> deviceCodes = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListDeviceCodesResponse other) {
            this.errors(other.getErrors());
            this.deviceCodes(other.getDeviceCodes());
            this.cursor(other.getCursor());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="device_codes", nulls=Nulls.SKIP)
        public Builder deviceCodes(Optional<List<DeviceCode>> deviceCodes) {
            this.deviceCodes = deviceCodes;
            return this;
        }

        public Builder deviceCodes(List<DeviceCode> deviceCodes) {
            this.deviceCodes = Optional.ofNullable(deviceCodes);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public ListDeviceCodesResponse build() {
            return new ListDeviceCodesResponse(this.errors, this.deviceCodes, this.cursor, this.additionalProperties);
        }
    }
}

