/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogObject;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListCatalogResponse {
    private final Optional<List<Error>> errors;
    private final Optional<String> cursor;
    private final Optional<List<CatalogObject>> objects;
    private final Map<String, Object> additionalProperties;

    private ListCatalogResponse(Optional<List<Error>> errors, Optional<String> cursor, Optional<List<CatalogObject>> objects, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.cursor = cursor;
        this.objects = objects;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="objects")
    public Optional<List<CatalogObject>> getObjects() {
        return this.objects;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListCatalogResponse && this.equalTo((ListCatalogResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCatalogResponse other) {
        return this.errors.equals(other.errors) && this.cursor.equals(other.cursor) && this.objects.equals(other.objects);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.cursor, this.objects);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<List<CatalogObject>> objects = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListCatalogResponse other) {
            this.errors(other.getErrors());
            this.cursor(other.getCursor());
            this.objects(other.getObjects());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="objects", nulls=Nulls.SKIP)
        public Builder objects(Optional<List<CatalogObject>> objects) {
            this.objects = objects;
            return this;
        }

        public Builder objects(List<CatalogObject> objects) {
            this.objects = Optional.ofNullable(objects);
            return this;
        }

        public ListCatalogResponse build() {
            return new ListCatalogResponse(this.errors, this.cursor, this.objects, this.additionalProperties);
        }
    }
}

