/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CashDrawerShiftSummary;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListCashDrawerShiftsResponse {
    private final Optional<String> cursor;
    private final Optional<List<Error>> errors;
    private final Optional<List<CashDrawerShiftSummary>> cashDrawerShifts;
    private final Map<String, Object> additionalProperties;

    private ListCashDrawerShiftsResponse(Optional<String> cursor, Optional<List<Error>> errors, Optional<List<CashDrawerShiftSummary>> cashDrawerShifts, Map<String, Object> additionalProperties) {
        this.cursor = cursor;
        this.errors = errors;
        this.cashDrawerShifts = cashDrawerShifts;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="cash_drawer_shifts")
    public Optional<List<CashDrawerShiftSummary>> getCashDrawerShifts() {
        return this.cashDrawerShifts;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListCashDrawerShiftsResponse && this.equalTo((ListCashDrawerShiftsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCashDrawerShiftsResponse other) {
        return this.cursor.equals(other.cursor) && this.errors.equals(other.errors) && this.cashDrawerShifts.equals(other.cashDrawerShifts);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.errors, this.cashDrawerShifts);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> cursor = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<CashDrawerShiftSummary>> cashDrawerShifts = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListCashDrawerShiftsResponse other) {
            this.cursor(other.getCursor());
            this.errors(other.getErrors());
            this.cashDrawerShifts(other.getCashDrawerShifts());
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="cash_drawer_shifts", nulls=Nulls.SKIP)
        public Builder cashDrawerShifts(Optional<List<CashDrawerShiftSummary>> cashDrawerShifts) {
            this.cashDrawerShifts = cashDrawerShifts;
            return this;
        }

        public Builder cashDrawerShifts(List<CashDrawerShiftSummary> cashDrawerShifts) {
            this.cashDrawerShifts = Optional.ofNullable(cashDrawerShifts);
            return this;
        }

        public ListCashDrawerShiftsResponse build() {
            return new ListCashDrawerShiftsResponse(this.cursor, this.errors, this.cashDrawerShifts, this.additionalProperties);
        }
    }
}

