/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LinkCustomerToGiftCardRequest {
    private final String giftCardId;
    private final String customerId;
    private final Map<String, Object> additionalProperties;

    private LinkCustomerToGiftCardRequest(String giftCardId, String customerId, Map<String, Object> additionalProperties) {
        this.giftCardId = giftCardId;
        this.customerId = customerId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="gift_card_id")
    public String getGiftCardId() {
        return this.giftCardId;
    }

    @JsonProperty(value="customer_id")
    public String getCustomerId() {
        return this.customerId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LinkCustomerToGiftCardRequest && this.equalTo((LinkCustomerToGiftCardRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LinkCustomerToGiftCardRequest other) {
        return this.giftCardId.equals(other.giftCardId) && this.customerId.equals(other.customerId);
    }

    public int hashCode() {
        return Objects.hash(this.giftCardId, this.customerId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GiftCardIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GiftCardIdStage,
    CustomerIdStage,
    _FinalStage {
        private String giftCardId;
        private String customerId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LinkCustomerToGiftCardRequest other) {
            this.giftCardId(other.getGiftCardId());
            this.customerId(other.getCustomerId());
            return this;
        }

        @Override
        @JsonSetter(value="gift_card_id")
        public CustomerIdStage giftCardId(@NotNull String giftCardId) {
            this.giftCardId = Objects.requireNonNull(giftCardId, "giftCardId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="customer_id")
        public _FinalStage customerId(@NotNull String customerId) {
            this.customerId = Objects.requireNonNull(customerId, "customerId must not be null");
            return this;
        }

        @Override
        public LinkCustomerToGiftCardRequest build() {
            return new LinkCustomerToGiftCardRequest(this.giftCardId, this.customerId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LinkCustomerToGiftCardRequest build();
    }

    public static interface CustomerIdStage {
        public _FinalStage customerId(@NotNull String var1);
    }

    public static interface GiftCardIdStage {
        public CustomerIdStage giftCardId(@NotNull String var1);

        public Builder from(LinkCustomerToGiftCardRequest var1);
    }
}

