/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Job;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class JobUpdatedEventObject {
    private final Optional<Job> job;
    private final Map<String, Object> additionalProperties;

    private JobUpdatedEventObject(Optional<Job> job, Map<String, Object> additionalProperties) {
        this.job = job;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="job")
    public Optional<Job> getJob() {
        return this.job;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JobUpdatedEventObject && this.equalTo((JobUpdatedEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(JobUpdatedEventObject other) {
        return this.job.equals(other.job);
    }

    public int hashCode() {
        return Objects.hash(this.job);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Job> job = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(JobUpdatedEventObject other) {
            this.job(other.getJob());
            return this;
        }

        @JsonSetter(value="job", nulls=Nulls.SKIP)
        public Builder job(Optional<Job> job) {
            this.job = job;
            return this;
        }

        public Builder job(Job job) {
            this.job = Optional.ofNullable(job);
            return this;
        }

        public JobUpdatedEventObject build() {
            return new JobUpdatedEventObject(this.job, this.additionalProperties);
        }
    }
}

