/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Job {
    private final Optional<String> id;
    private final Optional<String> title;
    private final Optional<Boolean> isTipEligible;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<Integer> version;
    private final Map<String, Object> additionalProperties;

    private Job(Optional<String> id, Optional<String> title, Optional<Boolean> isTipEligible, Optional<String> createdAt, Optional<String> updatedAt, Optional<Integer> version, Map<String, Object> additionalProperties) {
        this.id = id;
        this.title = title;
        this.isTipEligible = isTipEligible;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.version = version;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getTitle() {
        if (this.title == null) {
            return Optional.empty();
        }
        return this.title;
    }

    @JsonIgnore
    public Optional<Boolean> getIsTipEligible() {
        if (this.isTipEligible == null) {
            return Optional.empty();
        }
        return this.isTipEligible;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="title")
    private Optional<String> _getTitle() {
        return this.title;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_tip_eligible")
    private Optional<Boolean> _getIsTipEligible() {
        return this.isTipEligible;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Job && this.equalTo((Job)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Job other) {
        return this.id.equals(other.id) && this.title.equals(other.title) && this.isTipEligible.equals(other.isTipEligible) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.version.equals(other.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.isTipEligible, this.createdAt, this.updatedAt, this.version);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<Boolean> isTipEligible = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Job other) {
            this.id(other.getId());
            this.title(other.getTitle());
            this.isTipEligible(other.getIsTipEligible());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.version(other.getVersion());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        public Builder title(Nullable<String> title) {
            this.title = title.isNull() ? null : (title.isEmpty() ? Optional.empty() : Optional.of(title.get()));
            return this;
        }

        @JsonSetter(value="is_tip_eligible", nulls=Nulls.SKIP)
        public Builder isTipEligible(Optional<Boolean> isTipEligible) {
            this.isTipEligible = isTipEligible;
            return this;
        }

        public Builder isTipEligible(Boolean isTipEligible) {
            this.isTipEligible = Optional.ofNullable(isTipEligible);
            return this;
        }

        public Builder isTipEligible(Nullable<Boolean> isTipEligible) {
            this.isTipEligible = isTipEligible.isNull() ? null : (isTipEligible.isEmpty() ? Optional.empty() : Optional.of(isTipEligible.get()));
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        public Builder version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        public Job build() {
            return new Job(this.id, this.title, this.isTipEligible, this.createdAt, this.updatedAt, this.version, this.additionalProperties);
        }
    }
}

