/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SortOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InvoiceSort {
    private final String field;
    private final Optional<SortOrder> order;
    private final Map<String, Object> additionalProperties;

    private InvoiceSort(String field, Optional<SortOrder> order, Map<String, Object> additionalProperties) {
        this.field = field;
        this.order = order;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="field")
    public String getField() {
        return this.field;
    }

    @JsonProperty(value="order")
    public Optional<SortOrder> getOrder() {
        return this.order;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InvoiceSort && this.equalTo((InvoiceSort)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InvoiceSort other) {
        return this.field.equals(other.field) && this.order.equals(other.order);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.order);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static FieldStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements FieldStage,
    _FinalStage {
        private String field;
        private Optional<SortOrder> order = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(InvoiceSort other) {
            this.field(other.getField());
            this.order(other.getOrder());
            return this;
        }

        @Override
        @JsonSetter(value="field")
        public _FinalStage field(@NotNull String field) {
            this.field = Objects.requireNonNull(field, "field must not be null");
            return this;
        }

        @Override
        public _FinalStage order(SortOrder order) {
            this.order = Optional.ofNullable(order);
            return this;
        }

        @Override
        @JsonSetter(value="order", nulls=Nulls.SKIP)
        public _FinalStage order(Optional<SortOrder> order) {
            this.order = order;
            return this;
        }

        @Override
        public InvoiceSort build() {
            return new InvoiceSort(this.field, this.order, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public InvoiceSort build();

        public _FinalStage order(Optional<SortOrder> var1);

        public _FinalStage order(SortOrder var1);
    }

    public static interface FieldStage {
        public _FinalStage field(@NotNull String var1);

        public Builder from(InvoiceSort var1);
    }
}

