/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class InvoiceRequestType {
    public static final InvoiceRequestType INSTALLMENT = new InvoiceRequestType(Value.INSTALLMENT, "INSTALLMENT");
    public static final InvoiceRequestType DEPOSIT = new InvoiceRequestType(Value.DEPOSIT, "DEPOSIT");
    public static final InvoiceRequestType BALANCE = new InvoiceRequestType(Value.BALANCE, "BALANCE");
    private final Value value;
    private final String string;

    InvoiceRequestType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof InvoiceRequestType && this.string.equals(((InvoiceRequestType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case INSTALLMENT: {
                return visitor.visitInstallment();
            }
            case DEPOSIT: {
                return visitor.visitDeposit();
            }
            case BALANCE: {
                return visitor.visitBalance();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static InvoiceRequestType valueOf(String value) {
        switch (value) {
            case "INSTALLMENT": {
                return INSTALLMENT;
            }
            case "DEPOSIT": {
                return DEPOSIT;
            }
            case "BALANCE": {
                return BALANCE;
            }
        }
        return new InvoiceRequestType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitBalance();

        public T visitDeposit();

        public T visitInstallment();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        BALANCE,
        DEPOSIT,
        INSTALLMENT,
        UNKNOWN;

    }
}

