/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.InvoiceCustomFieldPlacement;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InvoiceCustomField {
    private final Optional<String> label;
    private final Optional<String> value;
    private final Optional<InvoiceCustomFieldPlacement> placement;
    private final Map<String, Object> additionalProperties;

    private InvoiceCustomField(Optional<String> label, Optional<String> value, Optional<InvoiceCustomFieldPlacement> placement, Map<String, Object> additionalProperties) {
        this.label = label;
        this.value = value;
        this.placement = placement;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getLabel() {
        if (this.label == null) {
            return Optional.empty();
        }
        return this.label;
    }

    @JsonIgnore
    public Optional<String> getValue() {
        if (this.value == null) {
            return Optional.empty();
        }
        return this.value;
    }

    @JsonProperty(value="placement")
    public Optional<InvoiceCustomFieldPlacement> getPlacement() {
        return this.placement;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="label")
    private Optional<String> _getLabel() {
        return this.label;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="value")
    private Optional<String> _getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InvoiceCustomField && this.equalTo((InvoiceCustomField)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InvoiceCustomField other) {
        return this.label.equals(other.label) && this.value.equals(other.value) && this.placement.equals(other.placement);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.value, this.placement);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> label = Optional.empty();
        private Optional<String> value = Optional.empty();
        private Optional<InvoiceCustomFieldPlacement> placement = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InvoiceCustomField other) {
            this.label(other.getLabel());
            this.value(other.getValue());
            this.placement(other.getPlacement());
            return this;
        }

        @JsonSetter(value="label", nulls=Nulls.SKIP)
        public Builder label(Optional<String> label) {
            this.label = label;
            return this;
        }

        public Builder label(String label) {
            this.label = Optional.ofNullable(label);
            return this;
        }

        public Builder label(Nullable<String> label) {
            this.label = label.isNull() ? null : (label.isEmpty() ? Optional.empty() : Optional.of(label.get()));
            return this;
        }

        @JsonSetter(value="value", nulls=Nulls.SKIP)
        public Builder value(Optional<String> value) {
            this.value = value;
            return this;
        }

        public Builder value(String value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        public Builder value(Nullable<String> value) {
            this.value = value.isNull() ? null : (value.isEmpty() ? Optional.empty() : Optional.of(value.get()));
            return this;
        }

        @JsonSetter(value="placement", nulls=Nulls.SKIP)
        public Builder placement(Optional<InvoiceCustomFieldPlacement> placement) {
            this.placement = placement;
            return this;
        }

        public Builder placement(InvoiceCustomFieldPlacement placement) {
            this.placement = Optional.ofNullable(placement);
            return this;
        }

        public InvoiceCustomField build() {
            return new InvoiceCustomField(this.label, this.value, this.placement, this.additionalProperties);
        }
    }
}

