/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Invoice;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InvoiceCanceledEventObject {
    private final Optional<Invoice> invoice;
    private final Map<String, Object> additionalProperties;

    private InvoiceCanceledEventObject(Optional<Invoice> invoice, Map<String, Object> additionalProperties) {
        this.invoice = invoice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="invoice")
    public Optional<Invoice> getInvoice() {
        return this.invoice;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InvoiceCanceledEventObject && this.equalTo((InvoiceCanceledEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InvoiceCanceledEventObject other) {
        return this.invoice.equals(other.invoice);
    }

    public int hashCode() {
        return Objects.hash(this.invoice);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Invoice> invoice = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InvoiceCanceledEventObject other) {
            this.invoice(other.getInvoice());
            return this;
        }

        @JsonSetter(value="invoice", nulls=Nulls.SKIP)
        public Builder invoice(Optional<Invoice> invoice) {
            this.invoice = invoice;
            return this;
        }

        public Builder invoice(Invoice invoice) {
            this.invoice = Optional.ofNullable(invoice);
            return this;
        }

        public InvoiceCanceledEventObject build() {
            return new InvoiceCanceledEventObject(this.invoice, this.additionalProperties);
        }
    }
}

