/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class InvoiceAutomaticPaymentSource {
    public static final InvoiceAutomaticPaymentSource BANK_ON_FILE = new InvoiceAutomaticPaymentSource(Value.BANK_ON_FILE, "BANK_ON_FILE");
    public static final InvoiceAutomaticPaymentSource CARD_ON_FILE = new InvoiceAutomaticPaymentSource(Value.CARD_ON_FILE, "CARD_ON_FILE");
    public static final InvoiceAutomaticPaymentSource NONE = new InvoiceAutomaticPaymentSource(Value.NONE, "NONE");
    private final Value value;
    private final String string;

    InvoiceAutomaticPaymentSource(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof InvoiceAutomaticPaymentSource && this.string.equals(((InvoiceAutomaticPaymentSource)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case BANK_ON_FILE: {
                return visitor.visitBankOnFile();
            }
            case CARD_ON_FILE: {
                return visitor.visitCardOnFile();
            }
            case NONE: {
                return visitor.visitNone();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static InvoiceAutomaticPaymentSource valueOf(String value) {
        switch (value) {
            case "BANK_ON_FILE": {
                return BANK_ON_FILE;
            }
            case "CARD_ON_FILE": {
                return CARD_ON_FILE;
            }
            case "NONE": {
                return NONE;
            }
        }
        return new InvoiceAutomaticPaymentSource(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitNone();

        public T visitCardOnFile();

        public T visitBankOnFile();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        NONE,
        CARD_ON_FILE,
        BANK_ON_FILE,
        UNKNOWN;

    }
}

