/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.InventoryState;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InventoryCount {
    private final Optional<String> catalogObjectId;
    private final Optional<String> catalogObjectType;
    private final Optional<InventoryState> state;
    private final Optional<String> locationId;
    private final Optional<String> quantity;
    private final Optional<String> calculatedAt;
    private final Optional<Boolean> isEstimated;
    private final Map<String, Object> additionalProperties;

    private InventoryCount(Optional<String> catalogObjectId, Optional<String> catalogObjectType, Optional<InventoryState> state, Optional<String> locationId, Optional<String> quantity, Optional<String> calculatedAt, Optional<Boolean> isEstimated, Map<String, Object> additionalProperties) {
        this.catalogObjectId = catalogObjectId;
        this.catalogObjectType = catalogObjectType;
        this.state = state;
        this.locationId = locationId;
        this.quantity = quantity;
        this.calculatedAt = calculatedAt;
        this.isEstimated = isEstimated;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getCatalogObjectId() {
        if (this.catalogObjectId == null) {
            return Optional.empty();
        }
        return this.catalogObjectId;
    }

    @JsonIgnore
    public Optional<String> getCatalogObjectType() {
        if (this.catalogObjectType == null) {
            return Optional.empty();
        }
        return this.catalogObjectType;
    }

    @JsonProperty(value="state")
    public Optional<InventoryState> getState() {
        return this.state;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getQuantity() {
        if (this.quantity == null) {
            return Optional.empty();
        }
        return this.quantity;
    }

    @JsonProperty(value="calculated_at")
    public Optional<String> getCalculatedAt() {
        return this.calculatedAt;
    }

    @JsonProperty(value="is_estimated")
    public Optional<Boolean> getIsEstimated() {
        return this.isEstimated;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_object_id")
    private Optional<String> _getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_object_type")
    private Optional<String> _getCatalogObjectType() {
        return this.catalogObjectType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="quantity")
    private Optional<String> _getQuantity() {
        return this.quantity;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InventoryCount && this.equalTo((InventoryCount)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InventoryCount other) {
        return this.catalogObjectId.equals(other.catalogObjectId) && this.catalogObjectType.equals(other.catalogObjectType) && this.state.equals(other.state) && this.locationId.equals(other.locationId) && this.quantity.equals(other.quantity) && this.calculatedAt.equals(other.calculatedAt) && this.isEstimated.equals(other.isEstimated);
    }

    public int hashCode() {
        return Objects.hash(this.catalogObjectId, this.catalogObjectType, this.state, this.locationId, this.quantity, this.calculatedAt, this.isEstimated);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> catalogObjectId = Optional.empty();
        private Optional<String> catalogObjectType = Optional.empty();
        private Optional<InventoryState> state = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> quantity = Optional.empty();
        private Optional<String> calculatedAt = Optional.empty();
        private Optional<Boolean> isEstimated = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InventoryCount other) {
            this.catalogObjectId(other.getCatalogObjectId());
            this.catalogObjectType(other.getCatalogObjectType());
            this.state(other.getState());
            this.locationId(other.getLocationId());
            this.quantity(other.getQuantity());
            this.calculatedAt(other.getCalculatedAt());
            this.isEstimated(other.getIsEstimated());
            return this;
        }

        @JsonSetter(value="catalog_object_id", nulls=Nulls.SKIP)
        public Builder catalogObjectId(Optional<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = Optional.ofNullable(catalogObjectId);
            return this;
        }

        public Builder catalogObjectId(Nullable<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId.isNull() ? null : (catalogObjectId.isEmpty() ? Optional.empty() : Optional.of(catalogObjectId.get()));
            return this;
        }

        @JsonSetter(value="catalog_object_type", nulls=Nulls.SKIP)
        public Builder catalogObjectType(Optional<String> catalogObjectType) {
            this.catalogObjectType = catalogObjectType;
            return this;
        }

        public Builder catalogObjectType(String catalogObjectType) {
            this.catalogObjectType = Optional.ofNullable(catalogObjectType);
            return this;
        }

        public Builder catalogObjectType(Nullable<String> catalogObjectType) {
            this.catalogObjectType = catalogObjectType.isNull() ? null : (catalogObjectType.isEmpty() ? Optional.empty() : Optional.of(catalogObjectType.get()));
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<InventoryState> state) {
            this.state = state;
            return this;
        }

        public Builder state(InventoryState state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="quantity", nulls=Nulls.SKIP)
        public Builder quantity(Optional<String> quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder quantity(String quantity) {
            this.quantity = Optional.ofNullable(quantity);
            return this;
        }

        public Builder quantity(Nullable<String> quantity) {
            this.quantity = quantity.isNull() ? null : (quantity.isEmpty() ? Optional.empty() : Optional.of(quantity.get()));
            return this;
        }

        @JsonSetter(value="calculated_at", nulls=Nulls.SKIP)
        public Builder calculatedAt(Optional<String> calculatedAt) {
            this.calculatedAt = calculatedAt;
            return this;
        }

        public Builder calculatedAt(String calculatedAt) {
            this.calculatedAt = Optional.ofNullable(calculatedAt);
            return this;
        }

        @JsonSetter(value="is_estimated", nulls=Nulls.SKIP)
        public Builder isEstimated(Optional<Boolean> isEstimated) {
            this.isEstimated = isEstimated;
            return this;
        }

        public Builder isEstimated(Boolean isEstimated) {
            this.isEstimated = Optional.ofNullable(isEstimated);
            return this;
        }

        public InventoryCount build() {
            return new InventoryCount(this.catalogObjectId, this.catalogObjectType, this.state, this.locationId, this.quantity, this.calculatedAt, this.isEstimated, this.additionalProperties);
        }
    }
}

