/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class InventoryChangeType {
    public static final InventoryChangeType TRANSFER = new InventoryChangeType(Value.TRANSFER, "TRANSFER");
    public static final InventoryChangeType PHYSICAL_COUNT = new InventoryChangeType(Value.PHYSICAL_COUNT, "PHYSICAL_COUNT");
    public static final InventoryChangeType ADJUSTMENT = new InventoryChangeType(Value.ADJUSTMENT, "ADJUSTMENT");
    private final Value value;
    private final String string;

    InventoryChangeType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof InventoryChangeType && this.string.equals(((InventoryChangeType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case TRANSFER: {
                return visitor.visitTransfer();
            }
            case PHYSICAL_COUNT: {
                return visitor.visitPhysicalCount();
            }
            case ADJUSTMENT: {
                return visitor.visitAdjustment();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static InventoryChangeType valueOf(String value) {
        switch (value) {
            case "TRANSFER": {
                return TRANSFER;
            }
            case "PHYSICAL_COUNT": {
                return PHYSICAL_COUNT;
            }
            case "ADJUSTMENT": {
                return ADJUSTMENT;
            }
        }
        return new InventoryChangeType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitPhysicalCount();

        public T visitAdjustment();

        public T visitTransfer();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        PHYSICAL_COUNT,
        ADJUSTMENT,
        TRANSFER,
        UNKNOWN;

    }
}

