/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogMeasurementUnit;
import com.squareup.square.types.InventoryAdjustment;
import com.squareup.square.types.InventoryChangeType;
import com.squareup.square.types.InventoryPhysicalCount;
import com.squareup.square.types.InventoryTransfer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InventoryChange {
    private final Optional<InventoryChangeType> type;
    private final Optional<InventoryPhysicalCount> physicalCount;
    private final Optional<InventoryAdjustment> adjustment;
    private final Optional<InventoryTransfer> transfer;
    private final Optional<CatalogMeasurementUnit> measurementUnit;
    private final Optional<String> measurementUnitId;
    private final Map<String, Object> additionalProperties;

    private InventoryChange(Optional<InventoryChangeType> type, Optional<InventoryPhysicalCount> physicalCount, Optional<InventoryAdjustment> adjustment, Optional<InventoryTransfer> transfer, Optional<CatalogMeasurementUnit> measurementUnit, Optional<String> measurementUnitId, Map<String, Object> additionalProperties) {
        this.type = type;
        this.physicalCount = physicalCount;
        this.adjustment = adjustment;
        this.transfer = transfer;
        this.measurementUnit = measurementUnit;
        this.measurementUnitId = measurementUnitId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<InventoryChangeType> getType() {
        return this.type;
    }

    @JsonProperty(value="physical_count")
    public Optional<InventoryPhysicalCount> getPhysicalCount() {
        return this.physicalCount;
    }

    @JsonProperty(value="adjustment")
    public Optional<InventoryAdjustment> getAdjustment() {
        return this.adjustment;
    }

    @JsonProperty(value="transfer")
    public Optional<InventoryTransfer> getTransfer() {
        return this.transfer;
    }

    @JsonProperty(value="measurement_unit")
    public Optional<CatalogMeasurementUnit> getMeasurementUnit() {
        return this.measurementUnit;
    }

    @JsonProperty(value="measurement_unit_id")
    public Optional<String> getMeasurementUnitId() {
        return this.measurementUnitId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InventoryChange && this.equalTo((InventoryChange)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InventoryChange other) {
        return this.type.equals(other.type) && this.physicalCount.equals(other.physicalCount) && this.adjustment.equals(other.adjustment) && this.transfer.equals(other.transfer) && this.measurementUnit.equals(other.measurementUnit) && this.measurementUnitId.equals(other.measurementUnitId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.physicalCount, this.adjustment, this.transfer, this.measurementUnit, this.measurementUnitId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<InventoryChangeType> type = Optional.empty();
        private Optional<InventoryPhysicalCount> physicalCount = Optional.empty();
        private Optional<InventoryAdjustment> adjustment = Optional.empty();
        private Optional<InventoryTransfer> transfer = Optional.empty();
        private Optional<CatalogMeasurementUnit> measurementUnit = Optional.empty();
        private Optional<String> measurementUnitId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InventoryChange other) {
            this.type(other.getType());
            this.physicalCount(other.getPhysicalCount());
            this.adjustment(other.getAdjustment());
            this.transfer(other.getTransfer());
            this.measurementUnit(other.getMeasurementUnit());
            this.measurementUnitId(other.getMeasurementUnitId());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<InventoryChangeType> type) {
            this.type = type;
            return this;
        }

        public Builder type(InventoryChangeType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="physical_count", nulls=Nulls.SKIP)
        public Builder physicalCount(Optional<InventoryPhysicalCount> physicalCount) {
            this.physicalCount = physicalCount;
            return this;
        }

        public Builder physicalCount(InventoryPhysicalCount physicalCount) {
            this.physicalCount = Optional.ofNullable(physicalCount);
            return this;
        }

        @JsonSetter(value="adjustment", nulls=Nulls.SKIP)
        public Builder adjustment(Optional<InventoryAdjustment> adjustment) {
            this.adjustment = adjustment;
            return this;
        }

        public Builder adjustment(InventoryAdjustment adjustment) {
            this.adjustment = Optional.ofNullable(adjustment);
            return this;
        }

        @JsonSetter(value="transfer", nulls=Nulls.SKIP)
        public Builder transfer(Optional<InventoryTransfer> transfer) {
            this.transfer = transfer;
            return this;
        }

        public Builder transfer(InventoryTransfer transfer) {
            this.transfer = Optional.ofNullable(transfer);
            return this;
        }

        @JsonSetter(value="measurement_unit", nulls=Nulls.SKIP)
        public Builder measurementUnit(Optional<CatalogMeasurementUnit> measurementUnit) {
            this.measurementUnit = measurementUnit;
            return this;
        }

        public Builder measurementUnit(CatalogMeasurementUnit measurementUnit) {
            this.measurementUnit = Optional.ofNullable(measurementUnit);
            return this;
        }

        @JsonSetter(value="measurement_unit_id", nulls=Nulls.SKIP)
        public Builder measurementUnitId(Optional<String> measurementUnitId) {
            this.measurementUnitId = measurementUnitId;
            return this;
        }

        public Builder measurementUnitId(String measurementUnitId) {
            this.measurementUnitId = Optional.ofNullable(measurementUnitId);
            return this;
        }

        public InventoryChange build() {
            return new InventoryChange(this.type, this.physicalCount, this.adjustment, this.transfer, this.measurementUnit, this.measurementUnitId, this.additionalProperties);
        }
    }
}

