/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.GiftCard;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GiftCardCustomerUnlinkedEventObject {
    private final Optional<GiftCard> giftCard;
    private final Optional<String> unlinkedCustomerId;
    private final Map<String, Object> additionalProperties;

    private GiftCardCustomerUnlinkedEventObject(Optional<GiftCard> giftCard, Optional<String> unlinkedCustomerId, Map<String, Object> additionalProperties) {
        this.giftCard = giftCard;
        this.unlinkedCustomerId = unlinkedCustomerId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="gift_card")
    public Optional<GiftCard> getGiftCard() {
        return this.giftCard;
    }

    @JsonIgnore
    public Optional<String> getUnlinkedCustomerId() {
        if (this.unlinkedCustomerId == null) {
            return Optional.empty();
        }
        return this.unlinkedCustomerId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="unlinked_customer_id")
    private Optional<String> _getUnlinkedCustomerId() {
        return this.unlinkedCustomerId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GiftCardCustomerUnlinkedEventObject && this.equalTo((GiftCardCustomerUnlinkedEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GiftCardCustomerUnlinkedEventObject other) {
        return this.giftCard.equals(other.giftCard) && this.unlinkedCustomerId.equals(other.unlinkedCustomerId);
    }

    public int hashCode() {
        return Objects.hash(this.giftCard, this.unlinkedCustomerId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<GiftCard> giftCard = Optional.empty();
        private Optional<String> unlinkedCustomerId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GiftCardCustomerUnlinkedEventObject other) {
            this.giftCard(other.getGiftCard());
            this.unlinkedCustomerId(other.getUnlinkedCustomerId());
            return this;
        }

        @JsonSetter(value="gift_card", nulls=Nulls.SKIP)
        public Builder giftCard(Optional<GiftCard> giftCard) {
            this.giftCard = giftCard;
            return this;
        }

        public Builder giftCard(GiftCard giftCard) {
            this.giftCard = Optional.ofNullable(giftCard);
            return this;
        }

        @JsonSetter(value="unlinked_customer_id", nulls=Nulls.SKIP)
        public Builder unlinkedCustomerId(Optional<String> unlinkedCustomerId) {
            this.unlinkedCustomerId = unlinkedCustomerId;
            return this;
        }

        public Builder unlinkedCustomerId(String unlinkedCustomerId) {
            this.unlinkedCustomerId = Optional.ofNullable(unlinkedCustomerId);
            return this;
        }

        public Builder unlinkedCustomerId(Nullable<String> unlinkedCustomerId) {
            this.unlinkedCustomerId = unlinkedCustomerId.isNull() ? null : (unlinkedCustomerId.isEmpty() ? Optional.empty() : Optional.of(unlinkedCustomerId.get()));
            return this;
        }

        public GiftCardCustomerUnlinkedEventObject build() {
            return new GiftCardCustomerUnlinkedEventObject(this.giftCard, this.unlinkedCustomerId, this.additionalProperties);
        }
    }
}

