/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GiftCardActivityTransferBalanceFrom {
    private final String transferToGiftCardId;
    private final Money amountMoney;
    private final Map<String, Object> additionalProperties;

    private GiftCardActivityTransferBalanceFrom(String transferToGiftCardId, Money amountMoney, Map<String, Object> additionalProperties) {
        this.transferToGiftCardId = transferToGiftCardId;
        this.amountMoney = amountMoney;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="transfer_to_gift_card_id")
    public String getTransferToGiftCardId() {
        return this.transferToGiftCardId;
    }

    @JsonProperty(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GiftCardActivityTransferBalanceFrom && this.equalTo((GiftCardActivityTransferBalanceFrom)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GiftCardActivityTransferBalanceFrom other) {
        return this.transferToGiftCardId.equals(other.transferToGiftCardId) && this.amountMoney.equals(other.amountMoney);
    }

    public int hashCode() {
        return Objects.hash(this.transferToGiftCardId, this.amountMoney);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TransferToGiftCardIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TransferToGiftCardIdStage,
    AmountMoneyStage,
    _FinalStage {
        private String transferToGiftCardId;
        private Money amountMoney;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GiftCardActivityTransferBalanceFrom other) {
            this.transferToGiftCardId(other.getTransferToGiftCardId());
            this.amountMoney(other.getAmountMoney());
            return this;
        }

        @Override
        @JsonSetter(value="transfer_to_gift_card_id")
        public AmountMoneyStage transferToGiftCardId(@NotNull String transferToGiftCardId) {
            this.transferToGiftCardId = Objects.requireNonNull(transferToGiftCardId, "transferToGiftCardId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="amount_money")
        public _FinalStage amountMoney(@NotNull Money amountMoney) {
            this.amountMoney = Objects.requireNonNull(amountMoney, "amountMoney must not be null");
            return this;
        }

        @Override
        public GiftCardActivityTransferBalanceFrom build() {
            return new GiftCardActivityTransferBalanceFrom(this.transferToGiftCardId, this.amountMoney, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GiftCardActivityTransferBalanceFrom build();
    }

    public static interface AmountMoneyStage {
        public _FinalStage amountMoney(@NotNull Money var1);
    }

    public static interface TransferToGiftCardIdStage {
        public AmountMoneyStage transferToGiftCardId(@NotNull String var1);

        public Builder from(GiftCardActivityTransferBalanceFrom var1);
    }
}

