/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GiftCardActivityRefund {
    private final Optional<String> redeemActivityId;
    private final Optional<Money> amountMoney;
    private final Optional<String> referenceId;
    private final Optional<String> paymentId;
    private final Map<String, Object> additionalProperties;

    private GiftCardActivityRefund(Optional<String> redeemActivityId, Optional<Money> amountMoney, Optional<String> referenceId, Optional<String> paymentId, Map<String, Object> additionalProperties) {
        this.redeemActivityId = redeemActivityId;
        this.amountMoney = amountMoney;
        this.referenceId = referenceId;
        this.paymentId = paymentId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getRedeemActivityId() {
        if (this.redeemActivityId == null) {
            return Optional.empty();
        }
        return this.redeemActivityId;
    }

    @JsonProperty(value="amount_money")
    public Optional<Money> getAmountMoney() {
        return this.amountMoney;
    }

    @JsonIgnore
    public Optional<String> getReferenceId() {
        if (this.referenceId == null) {
            return Optional.empty();
        }
        return this.referenceId;
    }

    @JsonProperty(value="payment_id")
    public Optional<String> getPaymentId() {
        return this.paymentId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="redeem_activity_id")
    private Optional<String> _getRedeemActivityId() {
        return this.redeemActivityId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reference_id")
    private Optional<String> _getReferenceId() {
        return this.referenceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GiftCardActivityRefund && this.equalTo((GiftCardActivityRefund)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GiftCardActivityRefund other) {
        return this.redeemActivityId.equals(other.redeemActivityId) && this.amountMoney.equals(other.amountMoney) && this.referenceId.equals(other.referenceId) && this.paymentId.equals(other.paymentId);
    }

    public int hashCode() {
        return Objects.hash(this.redeemActivityId, this.amountMoney, this.referenceId, this.paymentId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> redeemActivityId = Optional.empty();
        private Optional<Money> amountMoney = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<String> paymentId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GiftCardActivityRefund other) {
            this.redeemActivityId(other.getRedeemActivityId());
            this.amountMoney(other.getAmountMoney());
            this.referenceId(other.getReferenceId());
            this.paymentId(other.getPaymentId());
            return this;
        }

        @JsonSetter(value="redeem_activity_id", nulls=Nulls.SKIP)
        public Builder redeemActivityId(Optional<String> redeemActivityId) {
            this.redeemActivityId = redeemActivityId;
            return this;
        }

        public Builder redeemActivityId(String redeemActivityId) {
            this.redeemActivityId = Optional.ofNullable(redeemActivityId);
            return this;
        }

        public Builder redeemActivityId(Nullable<String> redeemActivityId) {
            this.redeemActivityId = redeemActivityId.isNull() ? null : (redeemActivityId.isEmpty() ? Optional.empty() : Optional.of(redeemActivityId.get()));
            return this;
        }

        @JsonSetter(value="amount_money", nulls=Nulls.SKIP)
        public Builder amountMoney(Optional<Money> amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = Optional.ofNullable(amountMoney);
            return this;
        }

        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public Builder referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        public Builder referenceId(Nullable<String> referenceId) {
            this.referenceId = referenceId.isNull() ? null : (referenceId.isEmpty() ? Optional.empty() : Optional.of(referenceId.get()));
            return this;
        }

        @JsonSetter(value="payment_id", nulls=Nulls.SKIP)
        public Builder paymentId(Optional<String> paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = Optional.ofNullable(paymentId);
            return this;
        }

        public GiftCardActivityRefund build() {
            return new GiftCardActivityRefund(this.redeemActivityId, this.amountMoney, this.referenceId, this.paymentId, this.additionalProperties);
        }
    }
}

