/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.GiftCardActivityRedeemStatus;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GiftCardActivityRedeem {
    private final Money amountMoney;
    private final Optional<String> paymentId;
    private final Optional<String> referenceId;
    private final Optional<GiftCardActivityRedeemStatus> status;
    private final Map<String, Object> additionalProperties;

    private GiftCardActivityRedeem(Money amountMoney, Optional<String> paymentId, Optional<String> referenceId, Optional<GiftCardActivityRedeemStatus> status, Map<String, Object> additionalProperties) {
        this.amountMoney = amountMoney;
        this.paymentId = paymentId;
        this.referenceId = referenceId;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonProperty(value="payment_id")
    public Optional<String> getPaymentId() {
        return this.paymentId;
    }

    @JsonIgnore
    public Optional<String> getReferenceId() {
        if (this.referenceId == null) {
            return Optional.empty();
        }
        return this.referenceId;
    }

    @JsonProperty(value="status")
    public Optional<GiftCardActivityRedeemStatus> getStatus() {
        return this.status;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reference_id")
    private Optional<String> _getReferenceId() {
        return this.referenceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GiftCardActivityRedeem && this.equalTo((GiftCardActivityRedeem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GiftCardActivityRedeem other) {
        return this.amountMoney.equals(other.amountMoney) && this.paymentId.equals(other.paymentId) && this.referenceId.equals(other.referenceId) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.amountMoney, this.paymentId, this.referenceId, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AmountMoneyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AmountMoneyStage,
    _FinalStage {
        private Money amountMoney;
        private Optional<GiftCardActivityRedeemStatus> status = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<String> paymentId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GiftCardActivityRedeem other) {
            this.amountMoney(other.getAmountMoney());
            this.paymentId(other.getPaymentId());
            this.referenceId(other.getReferenceId());
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="amount_money")
        public _FinalStage amountMoney(@NotNull Money amountMoney) {
            this.amountMoney = Objects.requireNonNull(amountMoney, "amountMoney must not be null");
            return this;
        }

        @Override
        public _FinalStage status(GiftCardActivityRedeemStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<GiftCardActivityRedeemStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage referenceId(Nullable<String> referenceId) {
            this.referenceId = referenceId.isNull() ? null : (referenceId.isEmpty() ? Optional.empty() : Optional.of(referenceId.get()));
            return this;
        }

        @Override
        public _FinalStage referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        @Override
        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public _FinalStage referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @Override
        public _FinalStage paymentId(String paymentId) {
            this.paymentId = Optional.ofNullable(paymentId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_id", nulls=Nulls.SKIP)
        public _FinalStage paymentId(Optional<String> paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        @Override
        public GiftCardActivityRedeem build() {
            return new GiftCardActivityRedeem(this.amountMoney, this.paymentId, this.referenceId, this.status, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GiftCardActivityRedeem build();

        public _FinalStage paymentId(Optional<String> var1);

        public _FinalStage paymentId(String var1);

        public _FinalStage referenceId(Optional<String> var1);

        public _FinalStage referenceId(String var1);

        public _FinalStage referenceId(Nullable<String> var1);

        public _FinalStage status(Optional<GiftCardActivityRedeemStatus> var1);

        public _FinalStage status(GiftCardActivityRedeemStatus var1);
    }

    public static interface AmountMoneyStage {
        public _FinalStage amountMoney(@NotNull Money var1);

        public Builder from(GiftCardActivityRedeem var1);
    }
}

