/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.GiftCardGanSource;
import com.squareup.square.types.GiftCardStatus;
import com.squareup.square.types.GiftCardType;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GiftCard {
    private final Optional<String> id;
    private final GiftCardType type;
    private final Optional<GiftCardGanSource> ganSource;
    private final Optional<GiftCardStatus> state;
    private final Optional<Money> balanceMoney;
    private final Optional<String> gan;
    private final Optional<String> createdAt;
    private final Optional<List<String>> customerIds;
    private final Map<String, Object> additionalProperties;

    private GiftCard(Optional<String> id, GiftCardType type, Optional<GiftCardGanSource> ganSource, Optional<GiftCardStatus> state, Optional<Money> balanceMoney, Optional<String> gan, Optional<String> createdAt, Optional<List<String>> customerIds, Map<String, Object> additionalProperties) {
        this.id = id;
        this.type = type;
        this.ganSource = ganSource;
        this.state = state;
        this.balanceMoney = balanceMoney;
        this.gan = gan;
        this.createdAt = createdAt;
        this.customerIds = customerIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="type")
    public GiftCardType getType() {
        return this.type;
    }

    @JsonProperty(value="gan_source")
    public Optional<GiftCardGanSource> getGanSource() {
        return this.ganSource;
    }

    @JsonProperty(value="state")
    public Optional<GiftCardStatus> getState() {
        return this.state;
    }

    @JsonProperty(value="balance_money")
    public Optional<Money> getBalanceMoney() {
        return this.balanceMoney;
    }

    @JsonIgnore
    public Optional<String> getGan() {
        if (this.gan == null) {
            return Optional.empty();
        }
        return this.gan;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="customer_ids")
    public Optional<List<String>> getCustomerIds() {
        return this.customerIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="gan")
    private Optional<String> _getGan() {
        return this.gan;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GiftCard && this.equalTo((GiftCard)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GiftCard other) {
        return this.id.equals(other.id) && this.type.equals(other.type) && this.ganSource.equals(other.ganSource) && this.state.equals(other.state) && this.balanceMoney.equals(other.balanceMoney) && this.gan.equals(other.gan) && this.createdAt.equals(other.createdAt) && this.customerIds.equals(other.customerIds);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.ganSource, this.state, this.balanceMoney, this.gan, this.createdAt, this.customerIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    _FinalStage {
        private GiftCardType type;
        private Optional<List<String>> customerIds = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> gan = Optional.empty();
        private Optional<Money> balanceMoney = Optional.empty();
        private Optional<GiftCardStatus> state = Optional.empty();
        private Optional<GiftCardGanSource> ganSource = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GiftCard other) {
            this.id(other.getId());
            this.type(other.getType());
            this.ganSource(other.getGanSource());
            this.state(other.getState());
            this.balanceMoney(other.getBalanceMoney());
            this.gan(other.getGan());
            this.createdAt(other.getCreatedAt());
            this.customerIds(other.getCustomerIds());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public _FinalStage type(@NotNull GiftCardType type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        public _FinalStage customerIds(List<String> customerIds) {
            this.customerIds = Optional.ofNullable(customerIds);
            return this;
        }

        @Override
        @JsonSetter(value="customer_ids", nulls=Nulls.SKIP)
        public _FinalStage customerIds(Optional<List<String>> customerIds) {
            this.customerIds = customerIds;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage gan(Nullable<String> gan) {
            this.gan = gan.isNull() ? null : (gan.isEmpty() ? Optional.empty() : Optional.of(gan.get()));
            return this;
        }

        @Override
        public _FinalStage gan(String gan) {
            this.gan = Optional.ofNullable(gan);
            return this;
        }

        @Override
        @JsonSetter(value="gan", nulls=Nulls.SKIP)
        public _FinalStage gan(Optional<String> gan) {
            this.gan = gan;
            return this;
        }

        @Override
        public _FinalStage balanceMoney(Money balanceMoney) {
            this.balanceMoney = Optional.ofNullable(balanceMoney);
            return this;
        }

        @Override
        @JsonSetter(value="balance_money", nulls=Nulls.SKIP)
        public _FinalStage balanceMoney(Optional<Money> balanceMoney) {
            this.balanceMoney = balanceMoney;
            return this;
        }

        @Override
        public _FinalStage state(GiftCardStatus state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @Override
        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public _FinalStage state(Optional<GiftCardStatus> state) {
            this.state = state;
            return this;
        }

        @Override
        public _FinalStage ganSource(GiftCardGanSource ganSource) {
            this.ganSource = Optional.ofNullable(ganSource);
            return this;
        }

        @Override
        @JsonSetter(value="gan_source", nulls=Nulls.SKIP)
        public _FinalStage ganSource(Optional<GiftCardGanSource> ganSource) {
            this.ganSource = ganSource;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public GiftCard build() {
            return new GiftCard(this.id, this.type, this.ganSource, this.state, this.balanceMoney, this.gan, this.createdAt, this.customerIds, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GiftCard build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage ganSource(Optional<GiftCardGanSource> var1);

        public _FinalStage ganSource(GiftCardGanSource var1);

        public _FinalStage state(Optional<GiftCardStatus> var1);

        public _FinalStage state(GiftCardStatus var1);

        public _FinalStage balanceMoney(Optional<Money> var1);

        public _FinalStage balanceMoney(Money var1);

        public _FinalStage gan(Optional<String> var1);

        public _FinalStage gan(String var1);

        public _FinalStage gan(Nullable<String> var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage customerIds(Optional<List<String>> var1);

        public _FinalStage customerIds(List<String> var1);
    }

    public static interface TypeStage {
        public _FinalStage type(@NotNull GiftCardType var1);

        public Builder from(GiftCard var1);
    }
}

