/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.TerminalAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetTerminalActionResponse {
    private final Optional<List<Error>> errors;
    private final Optional<TerminalAction> action;
    private final Map<String, Object> additionalProperties;

    private GetTerminalActionResponse(Optional<List<Error>> errors, Optional<TerminalAction> action, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.action = action;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="action")
    public Optional<TerminalAction> getAction() {
        return this.action;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetTerminalActionResponse && this.equalTo((GetTerminalActionResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetTerminalActionResponse other) {
        return this.errors.equals(other.errors) && this.action.equals(other.action);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.action);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<TerminalAction> action = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetTerminalActionResponse other) {
            this.errors(other.getErrors());
            this.action(other.getAction());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="action", nulls=Nulls.SKIP)
        public Builder action(Optional<TerminalAction> action) {
            this.action = action;
            return this;
        }

        public Builder action(TerminalAction action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        public GetTerminalActionResponse build() {
            return new GetTerminalActionResponse(this.errors, this.action, this.additionalProperties);
        }
    }
}

