/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetSubscriptionsRequest {
    private final String subscriptionId;
    private final Optional<String> include;
    private final Map<String, Object> additionalProperties;

    private GetSubscriptionsRequest(String subscriptionId, Optional<String> include, Map<String, Object> additionalProperties) {
        this.subscriptionId = subscriptionId;
        this.include = include;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="subscription_id")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @JsonIgnore
    public Optional<String> getInclude() {
        if (this.include == null) {
            return Optional.empty();
        }
        return this.include;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="include")
    private Optional<String> _getInclude() {
        return this.include;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetSubscriptionsRequest && this.equalTo((GetSubscriptionsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetSubscriptionsRequest other) {
        return this.subscriptionId.equals(other.subscriptionId) && this.include.equals(other.include);
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionId, this.include);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SubscriptionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SubscriptionIdStage,
    _FinalStage {
        private String subscriptionId;
        private Optional<String> include = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetSubscriptionsRequest other) {
            this.subscriptionId(other.getSubscriptionId());
            this.include(other.getInclude());
            return this;
        }

        @Override
        @JsonSetter(value="subscription_id")
        public _FinalStage subscriptionId(@NotNull String subscriptionId) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId must not be null");
            return this;
        }

        @Override
        public _FinalStage include(Nullable<String> include) {
            this.include = include.isNull() ? null : (include.isEmpty() ? Optional.empty() : Optional.of(include.get()));
            return this;
        }

        @Override
        public _FinalStage include(String include) {
            this.include = Optional.ofNullable(include);
            return this;
        }

        @Override
        @JsonSetter(value="include", nulls=Nulls.SKIP)
        public _FinalStage include(Optional<String> include) {
            this.include = include;
            return this;
        }

        @Override
        public GetSubscriptionsRequest build() {
            return new GetSubscriptionsRequest(this.subscriptionId, this.include, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetSubscriptionsRequest build();

        public _FinalStage include(Optional<String> var1);

        public _FinalStage include(String var1);

        public _FinalStage include(Nullable<String> var1);
    }

    public static interface SubscriptionIdStage {
        public _FinalStage subscriptionId(@NotNull String var1);

        public Builder from(GetSubscriptionsRequest var1);
    }
}

