/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetMerchantsRequest {
    private final String merchantId;
    private final Map<String, Object> additionalProperties;

    private GetMerchantsRequest(String merchantId, Map<String, Object> additionalProperties) {
        this.merchantId = merchantId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="merchant_id")
    public String getMerchantId() {
        return this.merchantId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetMerchantsRequest && this.equalTo((GetMerchantsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetMerchantsRequest other) {
        return this.merchantId.equals(other.merchantId);
    }

    public int hashCode() {
        return Objects.hash(this.merchantId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MerchantIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MerchantIdStage,
    _FinalStage {
        private String merchantId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetMerchantsRequest other) {
            this.merchantId(other.getMerchantId());
            return this;
        }

        @Override
        @JsonSetter(value="merchant_id")
        public _FinalStage merchantId(@NotNull String merchantId) {
            this.merchantId = Objects.requireNonNull(merchantId, "merchantId must not be null");
            return this;
        }

        @Override
        public GetMerchantsRequest build() {
            return new GetMerchantsRequest(this.merchantId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetMerchantsRequest build();
    }

    public static interface MerchantIdStage {
        public _FinalStage merchantId(@NotNull String var1);

        public Builder from(GetMerchantsRequest var1);
    }
}

