/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.LoyaltyPromotion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetLoyaltyPromotionResponse {
    private final Optional<List<Error>> errors;
    private final Optional<LoyaltyPromotion> loyaltyPromotion;
    private final Map<String, Object> additionalProperties;

    private GetLoyaltyPromotionResponse(Optional<List<Error>> errors, Optional<LoyaltyPromotion> loyaltyPromotion, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.loyaltyPromotion = loyaltyPromotion;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="loyalty_promotion")
    public Optional<LoyaltyPromotion> getLoyaltyPromotion() {
        return this.loyaltyPromotion;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetLoyaltyPromotionResponse && this.equalTo((GetLoyaltyPromotionResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetLoyaltyPromotionResponse other) {
        return this.errors.equals(other.errors) && this.loyaltyPromotion.equals(other.loyaltyPromotion);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.loyaltyPromotion);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<LoyaltyPromotion> loyaltyPromotion = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetLoyaltyPromotionResponse other) {
            this.errors(other.getErrors());
            this.loyaltyPromotion(other.getLoyaltyPromotion());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="loyalty_promotion", nulls=Nulls.SKIP)
        public Builder loyaltyPromotion(Optional<LoyaltyPromotion> loyaltyPromotion) {
            this.loyaltyPromotion = loyaltyPromotion;
            return this;
        }

        public Builder loyaltyPromotion(LoyaltyPromotion loyaltyPromotion) {
            this.loyaltyPromotion = Optional.ofNullable(loyaltyPromotion);
            return this;
        }

        public GetLoyaltyPromotionResponse build() {
            return new GetLoyaltyPromotionResponse(this.errors, this.loyaltyPromotion, this.additionalProperties);
        }
    }
}

