/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetInventoryRequest {
    private final String catalogObjectId;
    private final Optional<String> locationIds;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private GetInventoryRequest(String catalogObjectId, Optional<String> locationIds, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.catalogObjectId = catalogObjectId;
        this.locationIds = locationIds;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="catalog_object_id")
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonIgnore
    public Optional<String> getLocationIds() {
        if (this.locationIds == null) {
            return Optional.empty();
        }
        return this.locationIds;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_ids")
    private Optional<String> _getLocationIds() {
        return this.locationIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetInventoryRequest && this.equalTo((GetInventoryRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetInventoryRequest other) {
        return this.catalogObjectId.equals(other.catalogObjectId) && this.locationIds.equals(other.locationIds) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.catalogObjectId, this.locationIds, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CatalogObjectIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CatalogObjectIdStage,
    _FinalStage {
        private String catalogObjectId;
        private Optional<String> cursor = Optional.empty();
        private Optional<String> locationIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetInventoryRequest other) {
            this.catalogObjectId(other.getCatalogObjectId());
            this.locationIds(other.getLocationIds());
            this.cursor(other.getCursor());
            return this;
        }

        @Override
        @JsonSetter(value="catalog_object_id")
        public _FinalStage catalogObjectId(@NotNull String catalogObjectId) {
            this.catalogObjectId = Objects.requireNonNull(catalogObjectId, "catalogObjectId must not be null");
            return this;
        }

        @Override
        public _FinalStage cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @Override
        public _FinalStage cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @Override
        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public _FinalStage cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        @Override
        public _FinalStage locationIds(Nullable<String> locationIds) {
            this.locationIds = locationIds.isNull() ? null : (locationIds.isEmpty() ? Optional.empty() : Optional.of(locationIds.get()));
            return this;
        }

        @Override
        public _FinalStage locationIds(String locationIds) {
            this.locationIds = Optional.ofNullable(locationIds);
            return this;
        }

        @Override
        @JsonSetter(value="location_ids", nulls=Nulls.SKIP)
        public _FinalStage locationIds(Optional<String> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        @Override
        public GetInventoryRequest build() {
            return new GetInventoryRequest(this.catalogObjectId, this.locationIds, this.cursor, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetInventoryRequest build();

        public _FinalStage locationIds(Optional<String> var1);

        public _FinalStage locationIds(String var1);

        public _FinalStage locationIds(Nullable<String> var1);

        public _FinalStage cursor(Optional<String> var1);

        public _FinalStage cursor(String var1);

        public _FinalStage cursor(Nullable<String> var1);
    }

    public static interface CatalogObjectIdStage {
        public _FinalStage catalogObjectId(@NotNull String var1);

        public Builder from(GetInventoryRequest var1);
    }
}

