/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.InventoryAdjustment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetInventoryAdjustmentResponse {
    private final Optional<List<Error>> errors;
    private final Optional<InventoryAdjustment> adjustment;
    private final Map<String, Object> additionalProperties;

    private GetInventoryAdjustmentResponse(Optional<List<Error>> errors, Optional<InventoryAdjustment> adjustment, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.adjustment = adjustment;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="adjustment")
    public Optional<InventoryAdjustment> getAdjustment() {
        return this.adjustment;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetInventoryAdjustmentResponse && this.equalTo((GetInventoryAdjustmentResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetInventoryAdjustmentResponse other) {
        return this.errors.equals(other.errors) && this.adjustment.equals(other.adjustment);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.adjustment);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<InventoryAdjustment> adjustment = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetInventoryAdjustmentResponse other) {
            this.errors(other.getErrors());
            this.adjustment(other.getAdjustment());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="adjustment", nulls=Nulls.SKIP)
        public Builder adjustment(Optional<InventoryAdjustment> adjustment) {
            this.adjustment = adjustment;
            return this;
        }

        public Builder adjustment(InventoryAdjustment adjustment) {
            this.adjustment = Optional.ofNullable(adjustment);
            return this;
        }

        public GetInventoryAdjustmentResponse build() {
            return new GetInventoryAdjustmentResponse(this.errors, this.adjustment, this.additionalProperties);
        }
    }
}

