/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DeviceCode;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetDeviceCodeResponse {
    private final Optional<List<Error>> errors;
    private final Optional<DeviceCode> deviceCode;
    private final Map<String, Object> additionalProperties;

    private GetDeviceCodeResponse(Optional<List<Error>> errors, Optional<DeviceCode> deviceCode, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.deviceCode = deviceCode;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="device_code")
    public Optional<DeviceCode> getDeviceCode() {
        return this.deviceCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetDeviceCodeResponse && this.equalTo((GetDeviceCodeResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetDeviceCodeResponse other) {
        return this.errors.equals(other.errors) && this.deviceCode.equals(other.deviceCode);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.deviceCode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<DeviceCode> deviceCode = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetDeviceCodeResponse other) {
            this.errors(other.getErrors());
            this.deviceCode(other.getDeviceCode());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="device_code", nulls=Nulls.SKIP)
        public Builder deviceCode(Optional<DeviceCode> deviceCode) {
            this.deviceCode = deviceCode;
            return this;
        }

        public Builder deviceCode(DeviceCode deviceCode) {
            this.deviceCode = Optional.ofNullable(deviceCode);
            return this;
        }

        public GetDeviceCodeResponse build() {
            return new GetDeviceCodeResponse(this.errors, this.deviceCode, this.additionalProperties);
        }
    }
}

