/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogObject;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetCatalogObjectResponse {
    private final Optional<List<Error>> errors;
    private final Optional<CatalogObject> object;
    private final Optional<List<CatalogObject>> relatedObjects;
    private final Map<String, Object> additionalProperties;

    private GetCatalogObjectResponse(Optional<List<Error>> errors, Optional<CatalogObject> object, Optional<List<CatalogObject>> relatedObjects, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.object = object;
        this.relatedObjects = relatedObjects;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="object")
    public Optional<CatalogObject> getObject() {
        return this.object;
    }

    @JsonProperty(value="related_objects")
    public Optional<List<CatalogObject>> getRelatedObjects() {
        return this.relatedObjects;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetCatalogObjectResponse && this.equalTo((GetCatalogObjectResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetCatalogObjectResponse other) {
        return this.errors.equals(other.errors) && this.object.equals(other.object) && this.relatedObjects.equals(other.relatedObjects);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.object, this.relatedObjects);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<CatalogObject> object = Optional.empty();
        private Optional<List<CatalogObject>> relatedObjects = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetCatalogObjectResponse other) {
            this.errors(other.getErrors());
            this.object(other.getObject());
            this.relatedObjects(other.getRelatedObjects());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="object", nulls=Nulls.SKIP)
        public Builder object(Optional<CatalogObject> object) {
            this.object = object;
            return this;
        }

        public Builder object(CatalogObject object) {
            this.object = Optional.ofNullable(object);
            return this;
        }

        @JsonSetter(value="related_objects", nulls=Nulls.SKIP)
        public Builder relatedObjects(Optional<List<CatalogObject>> relatedObjects) {
            this.relatedObjects = relatedObjects;
            return this;
        }

        public Builder relatedObjects(List<CatalogObject> relatedObjects) {
            this.relatedObjects = Optional.ofNullable(relatedObjects);
            return this;
        }

        public GetCatalogObjectResponse build() {
            return new GetCatalogObjectResponse(this.errors, this.object, this.relatedObjects, this.additionalProperties);
        }
    }
}

