/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.BusinessBookingProfile;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetBusinessBookingProfileResponse {
    private final Optional<BusinessBookingProfile> businessBookingProfile;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private GetBusinessBookingProfileResponse(Optional<BusinessBookingProfile> businessBookingProfile, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.businessBookingProfile = businessBookingProfile;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="business_booking_profile")
    public Optional<BusinessBookingProfile> getBusinessBookingProfile() {
        return this.businessBookingProfile;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetBusinessBookingProfileResponse && this.equalTo((GetBusinessBookingProfileResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetBusinessBookingProfileResponse other) {
        return this.businessBookingProfile.equals(other.businessBookingProfile) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.businessBookingProfile, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<BusinessBookingProfile> businessBookingProfile = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetBusinessBookingProfileResponse other) {
            this.businessBookingProfile(other.getBusinessBookingProfile());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="business_booking_profile", nulls=Nulls.SKIP)
        public Builder businessBookingProfile(Optional<BusinessBookingProfile> businessBookingProfile) {
            this.businessBookingProfile = businessBookingProfile;
            return this;
        }

        public Builder businessBookingProfile(BusinessBookingProfile businessBookingProfile) {
            this.businessBookingProfile = Optional.ofNullable(businessBookingProfile);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public GetBusinessBookingProfileResponse build() {
            return new GetBusinessBookingProfileResponse(this.businessBookingProfile, this.errors, this.additionalProperties);
        }
    }
}

