/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class FulfillmentType {
    public static final FulfillmentType PICKUP = new FulfillmentType(Value.PICKUP, "PICKUP");
    public static final FulfillmentType SHIPMENT = new FulfillmentType(Value.SHIPMENT, "SHIPMENT");
    public static final FulfillmentType DELIVERY = new FulfillmentType(Value.DELIVERY, "DELIVERY");
    private final Value value;
    private final String string;

    FulfillmentType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof FulfillmentType && this.string.equals(((FulfillmentType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case PICKUP: {
                return visitor.visitPickup();
            }
            case SHIPMENT: {
                return visitor.visitShipment();
            }
            case DELIVERY: {
                return visitor.visitDelivery();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static FulfillmentType valueOf(String value) {
        switch (value) {
            case "PICKUP": {
                return PICKUP;
            }
            case "SHIPMENT": {
                return SHIPMENT;
            }
            case "DELIVERY": {
                return DELIVERY;
            }
        }
        return new FulfillmentType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitPickup();

        public T visitShipment();

        public T visitDelivery();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        PICKUP,
        SHIPMENT,
        DELIVERY,
        UNKNOWN;

    }
}

