/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.FulfillmentDeliveryDetailsOrderFulfillmentDeliveryDetailsScheduleType;
import com.squareup.square.types.FulfillmentRecipient;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FulfillmentDeliveryDetails {
    private final Optional<FulfillmentRecipient> recipient;
    private final Optional<FulfillmentDeliveryDetailsOrderFulfillmentDeliveryDetailsScheduleType> scheduleType;
    private final Optional<String> placedAt;
    private final Optional<String> deliverAt;
    private final Optional<String> prepTimeDuration;
    private final Optional<String> deliveryWindowDuration;
    private final Optional<String> note;
    private final Optional<String> completedAt;
    private final Optional<String> inProgressAt;
    private final Optional<String> rejectedAt;
    private final Optional<String> readyAt;
    private final Optional<String> deliveredAt;
    private final Optional<String> canceledAt;
    private final Optional<String> cancelReason;
    private final Optional<String> courierPickupAt;
    private final Optional<String> courierPickupWindowDuration;
    private final Optional<Boolean> isNoContactDelivery;
    private final Optional<String> dropoffNotes;
    private final Optional<String> courierProviderName;
    private final Optional<String> courierSupportPhoneNumber;
    private final Optional<String> squareDeliveryId;
    private final Optional<String> externalDeliveryId;
    private final Optional<Boolean> managedDelivery;
    private final Map<String, Object> additionalProperties;

    private FulfillmentDeliveryDetails(Optional<FulfillmentRecipient> recipient, Optional<FulfillmentDeliveryDetailsOrderFulfillmentDeliveryDetailsScheduleType> scheduleType, Optional<String> placedAt, Optional<String> deliverAt, Optional<String> prepTimeDuration, Optional<String> deliveryWindowDuration, Optional<String> note, Optional<String> completedAt, Optional<String> inProgressAt, Optional<String> rejectedAt, Optional<String> readyAt, Optional<String> deliveredAt, Optional<String> canceledAt, Optional<String> cancelReason, Optional<String> courierPickupAt, Optional<String> courierPickupWindowDuration, Optional<Boolean> isNoContactDelivery, Optional<String> dropoffNotes, Optional<String> courierProviderName, Optional<String> courierSupportPhoneNumber, Optional<String> squareDeliveryId, Optional<String> externalDeliveryId, Optional<Boolean> managedDelivery, Map<String, Object> additionalProperties) {
        this.recipient = recipient;
        this.scheduleType = scheduleType;
        this.placedAt = placedAt;
        this.deliverAt = deliverAt;
        this.prepTimeDuration = prepTimeDuration;
        this.deliveryWindowDuration = deliveryWindowDuration;
        this.note = note;
        this.completedAt = completedAt;
        this.inProgressAt = inProgressAt;
        this.rejectedAt = rejectedAt;
        this.readyAt = readyAt;
        this.deliveredAt = deliveredAt;
        this.canceledAt = canceledAt;
        this.cancelReason = cancelReason;
        this.courierPickupAt = courierPickupAt;
        this.courierPickupWindowDuration = courierPickupWindowDuration;
        this.isNoContactDelivery = isNoContactDelivery;
        this.dropoffNotes = dropoffNotes;
        this.courierProviderName = courierProviderName;
        this.courierSupportPhoneNumber = courierSupportPhoneNumber;
        this.squareDeliveryId = squareDeliveryId;
        this.externalDeliveryId = externalDeliveryId;
        this.managedDelivery = managedDelivery;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="recipient")
    public Optional<FulfillmentRecipient> getRecipient() {
        return this.recipient;
    }

    @JsonProperty(value="schedule_type")
    public Optional<FulfillmentDeliveryDetailsOrderFulfillmentDeliveryDetailsScheduleType> getScheduleType() {
        return this.scheduleType;
    }

    @JsonProperty(value="placed_at")
    public Optional<String> getPlacedAt() {
        return this.placedAt;
    }

    @JsonIgnore
    public Optional<String> getDeliverAt() {
        if (this.deliverAt == null) {
            return Optional.empty();
        }
        return this.deliverAt;
    }

    @JsonIgnore
    public Optional<String> getPrepTimeDuration() {
        if (this.prepTimeDuration == null) {
            return Optional.empty();
        }
        return this.prepTimeDuration;
    }

    @JsonIgnore
    public Optional<String> getDeliveryWindowDuration() {
        if (this.deliveryWindowDuration == null) {
            return Optional.empty();
        }
        return this.deliveryWindowDuration;
    }

    @JsonIgnore
    public Optional<String> getNote() {
        if (this.note == null) {
            return Optional.empty();
        }
        return this.note;
    }

    @JsonIgnore
    public Optional<String> getCompletedAt() {
        if (this.completedAt == null) {
            return Optional.empty();
        }
        return this.completedAt;
    }

    @JsonProperty(value="in_progress_at")
    public Optional<String> getInProgressAt() {
        return this.inProgressAt;
    }

    @JsonProperty(value="rejected_at")
    public Optional<String> getRejectedAt() {
        return this.rejectedAt;
    }

    @JsonProperty(value="ready_at")
    public Optional<String> getReadyAt() {
        return this.readyAt;
    }

    @JsonProperty(value="delivered_at")
    public Optional<String> getDeliveredAt() {
        return this.deliveredAt;
    }

    @JsonProperty(value="canceled_at")
    public Optional<String> getCanceledAt() {
        return this.canceledAt;
    }

    @JsonIgnore
    public Optional<String> getCancelReason() {
        if (this.cancelReason == null) {
            return Optional.empty();
        }
        return this.cancelReason;
    }

    @JsonIgnore
    public Optional<String> getCourierPickupAt() {
        if (this.courierPickupAt == null) {
            return Optional.empty();
        }
        return this.courierPickupAt;
    }

    @JsonIgnore
    public Optional<String> getCourierPickupWindowDuration() {
        if (this.courierPickupWindowDuration == null) {
            return Optional.empty();
        }
        return this.courierPickupWindowDuration;
    }

    @JsonIgnore
    public Optional<Boolean> getIsNoContactDelivery() {
        if (this.isNoContactDelivery == null) {
            return Optional.empty();
        }
        return this.isNoContactDelivery;
    }

    @JsonIgnore
    public Optional<String> getDropoffNotes() {
        if (this.dropoffNotes == null) {
            return Optional.empty();
        }
        return this.dropoffNotes;
    }

    @JsonIgnore
    public Optional<String> getCourierProviderName() {
        if (this.courierProviderName == null) {
            return Optional.empty();
        }
        return this.courierProviderName;
    }

    @JsonIgnore
    public Optional<String> getCourierSupportPhoneNumber() {
        if (this.courierSupportPhoneNumber == null) {
            return Optional.empty();
        }
        return this.courierSupportPhoneNumber;
    }

    @JsonIgnore
    public Optional<String> getSquareDeliveryId() {
        if (this.squareDeliveryId == null) {
            return Optional.empty();
        }
        return this.squareDeliveryId;
    }

    @JsonIgnore
    public Optional<String> getExternalDeliveryId() {
        if (this.externalDeliveryId == null) {
            return Optional.empty();
        }
        return this.externalDeliveryId;
    }

    @JsonIgnore
    public Optional<Boolean> getManagedDelivery() {
        if (this.managedDelivery == null) {
            return Optional.empty();
        }
        return this.managedDelivery;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="deliver_at")
    private Optional<String> _getDeliverAt() {
        return this.deliverAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="prep_time_duration")
    private Optional<String> _getPrepTimeDuration() {
        return this.prepTimeDuration;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="delivery_window_duration")
    private Optional<String> _getDeliveryWindowDuration() {
        return this.deliveryWindowDuration;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="note")
    private Optional<String> _getNote() {
        return this.note;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="completed_at")
    private Optional<String> _getCompletedAt() {
        return this.completedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cancel_reason")
    private Optional<String> _getCancelReason() {
        return this.cancelReason;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="courier_pickup_at")
    private Optional<String> _getCourierPickupAt() {
        return this.courierPickupAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="courier_pickup_window_duration")
    private Optional<String> _getCourierPickupWindowDuration() {
        return this.courierPickupWindowDuration;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_no_contact_delivery")
    private Optional<Boolean> _getIsNoContactDelivery() {
        return this.isNoContactDelivery;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="dropoff_notes")
    private Optional<String> _getDropoffNotes() {
        return this.dropoffNotes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="courier_provider_name")
    private Optional<String> _getCourierProviderName() {
        return this.courierProviderName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="courier_support_phone_number")
    private Optional<String> _getCourierSupportPhoneNumber() {
        return this.courierSupportPhoneNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="square_delivery_id")
    private Optional<String> _getSquareDeliveryId() {
        return this.squareDeliveryId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="external_delivery_id")
    private Optional<String> _getExternalDeliveryId() {
        return this.externalDeliveryId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="managed_delivery")
    private Optional<Boolean> _getManagedDelivery() {
        return this.managedDelivery;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FulfillmentDeliveryDetails && this.equalTo((FulfillmentDeliveryDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FulfillmentDeliveryDetails other) {
        return this.recipient.equals(other.recipient) && this.scheduleType.equals(other.scheduleType) && this.placedAt.equals(other.placedAt) && this.deliverAt.equals(other.deliverAt) && this.prepTimeDuration.equals(other.prepTimeDuration) && this.deliveryWindowDuration.equals(other.deliveryWindowDuration) && this.note.equals(other.note) && this.completedAt.equals(other.completedAt) && this.inProgressAt.equals(other.inProgressAt) && this.rejectedAt.equals(other.rejectedAt) && this.readyAt.equals(other.readyAt) && this.deliveredAt.equals(other.deliveredAt) && this.canceledAt.equals(other.canceledAt) && this.cancelReason.equals(other.cancelReason) && this.courierPickupAt.equals(other.courierPickupAt) && this.courierPickupWindowDuration.equals(other.courierPickupWindowDuration) && this.isNoContactDelivery.equals(other.isNoContactDelivery) && this.dropoffNotes.equals(other.dropoffNotes) && this.courierProviderName.equals(other.courierProviderName) && this.courierSupportPhoneNumber.equals(other.courierSupportPhoneNumber) && this.squareDeliveryId.equals(other.squareDeliveryId) && this.externalDeliveryId.equals(other.externalDeliveryId) && this.managedDelivery.equals(other.managedDelivery);
    }

    public int hashCode() {
        return Objects.hash(this.recipient, this.scheduleType, this.placedAt, this.deliverAt, this.prepTimeDuration, this.deliveryWindowDuration, this.note, this.completedAt, this.inProgressAt, this.rejectedAt, this.readyAt, this.deliveredAt, this.canceledAt, this.cancelReason, this.courierPickupAt, this.courierPickupWindowDuration, this.isNoContactDelivery, this.dropoffNotes, this.courierProviderName, this.courierSupportPhoneNumber, this.squareDeliveryId, this.externalDeliveryId, this.managedDelivery);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<FulfillmentRecipient> recipient = Optional.empty();
        private Optional<FulfillmentDeliveryDetailsOrderFulfillmentDeliveryDetailsScheduleType> scheduleType = Optional.empty();
        private Optional<String> placedAt = Optional.empty();
        private Optional<String> deliverAt = Optional.empty();
        private Optional<String> prepTimeDuration = Optional.empty();
        private Optional<String> deliveryWindowDuration = Optional.empty();
        private Optional<String> note = Optional.empty();
        private Optional<String> completedAt = Optional.empty();
        private Optional<String> inProgressAt = Optional.empty();
        private Optional<String> rejectedAt = Optional.empty();
        private Optional<String> readyAt = Optional.empty();
        private Optional<String> deliveredAt = Optional.empty();
        private Optional<String> canceledAt = Optional.empty();
        private Optional<String> cancelReason = Optional.empty();
        private Optional<String> courierPickupAt = Optional.empty();
        private Optional<String> courierPickupWindowDuration = Optional.empty();
        private Optional<Boolean> isNoContactDelivery = Optional.empty();
        private Optional<String> dropoffNotes = Optional.empty();
        private Optional<String> courierProviderName = Optional.empty();
        private Optional<String> courierSupportPhoneNumber = Optional.empty();
        private Optional<String> squareDeliveryId = Optional.empty();
        private Optional<String> externalDeliveryId = Optional.empty();
        private Optional<Boolean> managedDelivery = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(FulfillmentDeliveryDetails other) {
            this.recipient(other.getRecipient());
            this.scheduleType(other.getScheduleType());
            this.placedAt(other.getPlacedAt());
            this.deliverAt(other.getDeliverAt());
            this.prepTimeDuration(other.getPrepTimeDuration());
            this.deliveryWindowDuration(other.getDeliveryWindowDuration());
            this.note(other.getNote());
            this.completedAt(other.getCompletedAt());
            this.inProgressAt(other.getInProgressAt());
            this.rejectedAt(other.getRejectedAt());
            this.readyAt(other.getReadyAt());
            this.deliveredAt(other.getDeliveredAt());
            this.canceledAt(other.getCanceledAt());
            this.cancelReason(other.getCancelReason());
            this.courierPickupAt(other.getCourierPickupAt());
            this.courierPickupWindowDuration(other.getCourierPickupWindowDuration());
            this.isNoContactDelivery(other.getIsNoContactDelivery());
            this.dropoffNotes(other.getDropoffNotes());
            this.courierProviderName(other.getCourierProviderName());
            this.courierSupportPhoneNumber(other.getCourierSupportPhoneNumber());
            this.squareDeliveryId(other.getSquareDeliveryId());
            this.externalDeliveryId(other.getExternalDeliveryId());
            this.managedDelivery(other.getManagedDelivery());
            return this;
        }

        @JsonSetter(value="recipient", nulls=Nulls.SKIP)
        public Builder recipient(Optional<FulfillmentRecipient> recipient) {
            this.recipient = recipient;
            return this;
        }

        public Builder recipient(FulfillmentRecipient recipient) {
            this.recipient = Optional.ofNullable(recipient);
            return this;
        }

        @JsonSetter(value="schedule_type", nulls=Nulls.SKIP)
        public Builder scheduleType(Optional<FulfillmentDeliveryDetailsOrderFulfillmentDeliveryDetailsScheduleType> scheduleType) {
            this.scheduleType = scheduleType;
            return this;
        }

        public Builder scheduleType(FulfillmentDeliveryDetailsOrderFulfillmentDeliveryDetailsScheduleType scheduleType) {
            this.scheduleType = Optional.ofNullable(scheduleType);
            return this;
        }

        @JsonSetter(value="placed_at", nulls=Nulls.SKIP)
        public Builder placedAt(Optional<String> placedAt) {
            this.placedAt = placedAt;
            return this;
        }

        public Builder placedAt(String placedAt) {
            this.placedAt = Optional.ofNullable(placedAt);
            return this;
        }

        @JsonSetter(value="deliver_at", nulls=Nulls.SKIP)
        public Builder deliverAt(Optional<String> deliverAt) {
            this.deliverAt = deliverAt;
            return this;
        }

        public Builder deliverAt(String deliverAt) {
            this.deliverAt = Optional.ofNullable(deliverAt);
            return this;
        }

        public Builder deliverAt(Nullable<String> deliverAt) {
            this.deliverAt = deliverAt.isNull() ? null : (deliverAt.isEmpty() ? Optional.empty() : Optional.of(deliverAt.get()));
            return this;
        }

        @JsonSetter(value="prep_time_duration", nulls=Nulls.SKIP)
        public Builder prepTimeDuration(Optional<String> prepTimeDuration) {
            this.prepTimeDuration = prepTimeDuration;
            return this;
        }

        public Builder prepTimeDuration(String prepTimeDuration) {
            this.prepTimeDuration = Optional.ofNullable(prepTimeDuration);
            return this;
        }

        public Builder prepTimeDuration(Nullable<String> prepTimeDuration) {
            this.prepTimeDuration = prepTimeDuration.isNull() ? null : (prepTimeDuration.isEmpty() ? Optional.empty() : Optional.of(prepTimeDuration.get()));
            return this;
        }

        @JsonSetter(value="delivery_window_duration", nulls=Nulls.SKIP)
        public Builder deliveryWindowDuration(Optional<String> deliveryWindowDuration) {
            this.deliveryWindowDuration = deliveryWindowDuration;
            return this;
        }

        public Builder deliveryWindowDuration(String deliveryWindowDuration) {
            this.deliveryWindowDuration = Optional.ofNullable(deliveryWindowDuration);
            return this;
        }

        public Builder deliveryWindowDuration(Nullable<String> deliveryWindowDuration) {
            this.deliveryWindowDuration = deliveryWindowDuration.isNull() ? null : (deliveryWindowDuration.isEmpty() ? Optional.empty() : Optional.of(deliveryWindowDuration.get()));
            return this;
        }

        @JsonSetter(value="note", nulls=Nulls.SKIP)
        public Builder note(Optional<String> note) {
            this.note = note;
            return this;
        }

        public Builder note(String note) {
            this.note = Optional.ofNullable(note);
            return this;
        }

        public Builder note(Nullable<String> note) {
            this.note = note.isNull() ? null : (note.isEmpty() ? Optional.empty() : Optional.of(note.get()));
            return this;
        }

        @JsonSetter(value="completed_at", nulls=Nulls.SKIP)
        public Builder completedAt(Optional<String> completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public Builder completedAt(String completedAt) {
            this.completedAt = Optional.ofNullable(completedAt);
            return this;
        }

        public Builder completedAt(Nullable<String> completedAt) {
            this.completedAt = completedAt.isNull() ? null : (completedAt.isEmpty() ? Optional.empty() : Optional.of(completedAt.get()));
            return this;
        }

        @JsonSetter(value="in_progress_at", nulls=Nulls.SKIP)
        public Builder inProgressAt(Optional<String> inProgressAt) {
            this.inProgressAt = inProgressAt;
            return this;
        }

        public Builder inProgressAt(String inProgressAt) {
            this.inProgressAt = Optional.ofNullable(inProgressAt);
            return this;
        }

        @JsonSetter(value="rejected_at", nulls=Nulls.SKIP)
        public Builder rejectedAt(Optional<String> rejectedAt) {
            this.rejectedAt = rejectedAt;
            return this;
        }

        public Builder rejectedAt(String rejectedAt) {
            this.rejectedAt = Optional.ofNullable(rejectedAt);
            return this;
        }

        @JsonSetter(value="ready_at", nulls=Nulls.SKIP)
        public Builder readyAt(Optional<String> readyAt) {
            this.readyAt = readyAt;
            return this;
        }

        public Builder readyAt(String readyAt) {
            this.readyAt = Optional.ofNullable(readyAt);
            return this;
        }

        @JsonSetter(value="delivered_at", nulls=Nulls.SKIP)
        public Builder deliveredAt(Optional<String> deliveredAt) {
            this.deliveredAt = deliveredAt;
            return this;
        }

        public Builder deliveredAt(String deliveredAt) {
            this.deliveredAt = Optional.ofNullable(deliveredAt);
            return this;
        }

        @JsonSetter(value="canceled_at", nulls=Nulls.SKIP)
        public Builder canceledAt(Optional<String> canceledAt) {
            this.canceledAt = canceledAt;
            return this;
        }

        public Builder canceledAt(String canceledAt) {
            this.canceledAt = Optional.ofNullable(canceledAt);
            return this;
        }

        @JsonSetter(value="cancel_reason", nulls=Nulls.SKIP)
        public Builder cancelReason(Optional<String> cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        public Builder cancelReason(String cancelReason) {
            this.cancelReason = Optional.ofNullable(cancelReason);
            return this;
        }

        public Builder cancelReason(Nullable<String> cancelReason) {
            this.cancelReason = cancelReason.isNull() ? null : (cancelReason.isEmpty() ? Optional.empty() : Optional.of(cancelReason.get()));
            return this;
        }

        @JsonSetter(value="courier_pickup_at", nulls=Nulls.SKIP)
        public Builder courierPickupAt(Optional<String> courierPickupAt) {
            this.courierPickupAt = courierPickupAt;
            return this;
        }

        public Builder courierPickupAt(String courierPickupAt) {
            this.courierPickupAt = Optional.ofNullable(courierPickupAt);
            return this;
        }

        public Builder courierPickupAt(Nullable<String> courierPickupAt) {
            this.courierPickupAt = courierPickupAt.isNull() ? null : (courierPickupAt.isEmpty() ? Optional.empty() : Optional.of(courierPickupAt.get()));
            return this;
        }

        @JsonSetter(value="courier_pickup_window_duration", nulls=Nulls.SKIP)
        public Builder courierPickupWindowDuration(Optional<String> courierPickupWindowDuration) {
            this.courierPickupWindowDuration = courierPickupWindowDuration;
            return this;
        }

        public Builder courierPickupWindowDuration(String courierPickupWindowDuration) {
            this.courierPickupWindowDuration = Optional.ofNullable(courierPickupWindowDuration);
            return this;
        }

        public Builder courierPickupWindowDuration(Nullable<String> courierPickupWindowDuration) {
            this.courierPickupWindowDuration = courierPickupWindowDuration.isNull() ? null : (courierPickupWindowDuration.isEmpty() ? Optional.empty() : Optional.of(courierPickupWindowDuration.get()));
            return this;
        }

        @JsonSetter(value="is_no_contact_delivery", nulls=Nulls.SKIP)
        public Builder isNoContactDelivery(Optional<Boolean> isNoContactDelivery) {
            this.isNoContactDelivery = isNoContactDelivery;
            return this;
        }

        public Builder isNoContactDelivery(Boolean isNoContactDelivery) {
            this.isNoContactDelivery = Optional.ofNullable(isNoContactDelivery);
            return this;
        }

        public Builder isNoContactDelivery(Nullable<Boolean> isNoContactDelivery) {
            this.isNoContactDelivery = isNoContactDelivery.isNull() ? null : (isNoContactDelivery.isEmpty() ? Optional.empty() : Optional.of(isNoContactDelivery.get()));
            return this;
        }

        @JsonSetter(value="dropoff_notes", nulls=Nulls.SKIP)
        public Builder dropoffNotes(Optional<String> dropoffNotes) {
            this.dropoffNotes = dropoffNotes;
            return this;
        }

        public Builder dropoffNotes(String dropoffNotes) {
            this.dropoffNotes = Optional.ofNullable(dropoffNotes);
            return this;
        }

        public Builder dropoffNotes(Nullable<String> dropoffNotes) {
            this.dropoffNotes = dropoffNotes.isNull() ? null : (dropoffNotes.isEmpty() ? Optional.empty() : Optional.of(dropoffNotes.get()));
            return this;
        }

        @JsonSetter(value="courier_provider_name", nulls=Nulls.SKIP)
        public Builder courierProviderName(Optional<String> courierProviderName) {
            this.courierProviderName = courierProviderName;
            return this;
        }

        public Builder courierProviderName(String courierProviderName) {
            this.courierProviderName = Optional.ofNullable(courierProviderName);
            return this;
        }

        public Builder courierProviderName(Nullable<String> courierProviderName) {
            this.courierProviderName = courierProviderName.isNull() ? null : (courierProviderName.isEmpty() ? Optional.empty() : Optional.of(courierProviderName.get()));
            return this;
        }

        @JsonSetter(value="courier_support_phone_number", nulls=Nulls.SKIP)
        public Builder courierSupportPhoneNumber(Optional<String> courierSupportPhoneNumber) {
            this.courierSupportPhoneNumber = courierSupportPhoneNumber;
            return this;
        }

        public Builder courierSupportPhoneNumber(String courierSupportPhoneNumber) {
            this.courierSupportPhoneNumber = Optional.ofNullable(courierSupportPhoneNumber);
            return this;
        }

        public Builder courierSupportPhoneNumber(Nullable<String> courierSupportPhoneNumber) {
            this.courierSupportPhoneNumber = courierSupportPhoneNumber.isNull() ? null : (courierSupportPhoneNumber.isEmpty() ? Optional.empty() : Optional.of(courierSupportPhoneNumber.get()));
            return this;
        }

        @JsonSetter(value="square_delivery_id", nulls=Nulls.SKIP)
        public Builder squareDeliveryId(Optional<String> squareDeliveryId) {
            this.squareDeliveryId = squareDeliveryId;
            return this;
        }

        public Builder squareDeliveryId(String squareDeliveryId) {
            this.squareDeliveryId = Optional.ofNullable(squareDeliveryId);
            return this;
        }

        public Builder squareDeliveryId(Nullable<String> squareDeliveryId) {
            this.squareDeliveryId = squareDeliveryId.isNull() ? null : (squareDeliveryId.isEmpty() ? Optional.empty() : Optional.of(squareDeliveryId.get()));
            return this;
        }

        @JsonSetter(value="external_delivery_id", nulls=Nulls.SKIP)
        public Builder externalDeliveryId(Optional<String> externalDeliveryId) {
            this.externalDeliveryId = externalDeliveryId;
            return this;
        }

        public Builder externalDeliveryId(String externalDeliveryId) {
            this.externalDeliveryId = Optional.ofNullable(externalDeliveryId);
            return this;
        }

        public Builder externalDeliveryId(Nullable<String> externalDeliveryId) {
            this.externalDeliveryId = externalDeliveryId.isNull() ? null : (externalDeliveryId.isEmpty() ? Optional.empty() : Optional.of(externalDeliveryId.get()));
            return this;
        }

        @JsonSetter(value="managed_delivery", nulls=Nulls.SKIP)
        public Builder managedDelivery(Optional<Boolean> managedDelivery) {
            this.managedDelivery = managedDelivery;
            return this;
        }

        public Builder managedDelivery(Boolean managedDelivery) {
            this.managedDelivery = Optional.ofNullable(managedDelivery);
            return this;
        }

        public Builder managedDelivery(Nullable<Boolean> managedDelivery) {
            this.managedDelivery = managedDelivery.isNull() ? null : (managedDelivery.isEmpty() ? Optional.empty() : Optional.of(managedDelivery.get()));
            return this;
        }

        public FulfillmentDeliveryDetails build() {
            return new FulfillmentDeliveryDetails(this.recipient, this.scheduleType, this.placedAt, this.deliverAt, this.prepTimeDuration, this.deliveryWindowDuration, this.note, this.completedAt, this.inProgressAt, this.rejectedAt, this.readyAt, this.deliveredAt, this.canceledAt, this.cancelReason, this.courierPickupAt, this.courierPickupWindowDuration, this.isNoContactDelivery, this.dropoffNotes, this.courierProviderName, this.courierSupportPhoneNumber, this.squareDeliveryId, this.externalDeliveryId, this.managedDelivery, this.additionalProperties);
        }
    }
}

