/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.FulfillmentDeliveryDetails;
import com.squareup.square.types.FulfillmentFulfillmentEntry;
import com.squareup.square.types.FulfillmentFulfillmentLineItemApplication;
import com.squareup.square.types.FulfillmentPickupDetails;
import com.squareup.square.types.FulfillmentShipmentDetails;
import com.squareup.square.types.FulfillmentState;
import com.squareup.square.types.FulfillmentType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Fulfillment {
    private final Optional<String> uid;
    private final Optional<FulfillmentType> type;
    private final Optional<FulfillmentState> state;
    private final Optional<FulfillmentFulfillmentLineItemApplication> lineItemApplication;
    private final Optional<List<FulfillmentFulfillmentEntry>> entries;
    private final Optional<Map<String, Optional<String>>> metadata;
    private final Optional<FulfillmentPickupDetails> pickupDetails;
    private final Optional<FulfillmentShipmentDetails> shipmentDetails;
    private final Optional<FulfillmentDeliveryDetails> deliveryDetails;
    private final Map<String, Object> additionalProperties;

    private Fulfillment(Optional<String> uid, Optional<FulfillmentType> type, Optional<FulfillmentState> state, Optional<FulfillmentFulfillmentLineItemApplication> lineItemApplication, Optional<List<FulfillmentFulfillmentEntry>> entries, Optional<Map<String, Optional<String>>> metadata, Optional<FulfillmentPickupDetails> pickupDetails, Optional<FulfillmentShipmentDetails> shipmentDetails, Optional<FulfillmentDeliveryDetails> deliveryDetails, Map<String, Object> additionalProperties) {
        this.uid = uid;
        this.type = type;
        this.state = state;
        this.lineItemApplication = lineItemApplication;
        this.entries = entries;
        this.metadata = metadata;
        this.pickupDetails = pickupDetails;
        this.shipmentDetails = shipmentDetails;
        this.deliveryDetails = deliveryDetails;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getUid() {
        if (this.uid == null) {
            return Optional.empty();
        }
        return this.uid;
    }

    @JsonProperty(value="type")
    public Optional<FulfillmentType> getType() {
        return this.type;
    }

    @JsonProperty(value="state")
    public Optional<FulfillmentState> getState() {
        return this.state;
    }

    @JsonProperty(value="line_item_application")
    public Optional<FulfillmentFulfillmentLineItemApplication> getLineItemApplication() {
        return this.lineItemApplication;
    }

    @JsonProperty(value="entries")
    public Optional<List<FulfillmentFulfillmentEntry>> getEntries() {
        return this.entries;
    }

    @JsonIgnore
    public Optional<Map<String, Optional<String>>> getMetadata() {
        if (this.metadata == null) {
            return Optional.empty();
        }
        return this.metadata;
    }

    @JsonProperty(value="pickup_details")
    public Optional<FulfillmentPickupDetails> getPickupDetails() {
        return this.pickupDetails;
    }

    @JsonProperty(value="shipment_details")
    public Optional<FulfillmentShipmentDetails> getShipmentDetails() {
        return this.shipmentDetails;
    }

    @JsonProperty(value="delivery_details")
    public Optional<FulfillmentDeliveryDetails> getDeliveryDetails() {
        return this.deliveryDetails;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="uid")
    private Optional<String> _getUid() {
        return this.uid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="metadata")
    private Optional<Map<String, Optional<String>>> _getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Fulfillment && this.equalTo((Fulfillment)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Fulfillment other) {
        return this.uid.equals(other.uid) && this.type.equals(other.type) && this.state.equals(other.state) && this.lineItemApplication.equals(other.lineItemApplication) && this.entries.equals(other.entries) && this.metadata.equals(other.metadata) && this.pickupDetails.equals(other.pickupDetails) && this.shipmentDetails.equals(other.shipmentDetails) && this.deliveryDetails.equals(other.deliveryDetails);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.type, this.state, this.lineItemApplication, this.entries, this.metadata, this.pickupDetails, this.shipmentDetails, this.deliveryDetails);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> uid = Optional.empty();
        private Optional<FulfillmentType> type = Optional.empty();
        private Optional<FulfillmentState> state = Optional.empty();
        private Optional<FulfillmentFulfillmentLineItemApplication> lineItemApplication = Optional.empty();
        private Optional<List<FulfillmentFulfillmentEntry>> entries = Optional.empty();
        private Optional<Map<String, Optional<String>>> metadata = Optional.empty();
        private Optional<FulfillmentPickupDetails> pickupDetails = Optional.empty();
        private Optional<FulfillmentShipmentDetails> shipmentDetails = Optional.empty();
        private Optional<FulfillmentDeliveryDetails> deliveryDetails = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Fulfillment other) {
            this.uid(other.getUid());
            this.type(other.getType());
            this.state(other.getState());
            this.lineItemApplication(other.getLineItemApplication());
            this.entries(other.getEntries());
            this.metadata(other.getMetadata());
            this.pickupDetails(other.getPickupDetails());
            this.shipmentDetails(other.getShipmentDetails());
            this.deliveryDetails(other.getDeliveryDetails());
            return this;
        }

        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public Builder uid(Optional<String> uid) {
            this.uid = uid;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = Optional.ofNullable(uid);
            return this;
        }

        public Builder uid(Nullable<String> uid) {
            this.uid = uid.isNull() ? null : (uid.isEmpty() ? Optional.empty() : Optional.of(uid.get()));
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<FulfillmentType> type) {
            this.type = type;
            return this;
        }

        public Builder type(FulfillmentType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<FulfillmentState> state) {
            this.state = state;
            return this;
        }

        public Builder state(FulfillmentState state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="line_item_application", nulls=Nulls.SKIP)
        public Builder lineItemApplication(Optional<FulfillmentFulfillmentLineItemApplication> lineItemApplication) {
            this.lineItemApplication = lineItemApplication;
            return this;
        }

        public Builder lineItemApplication(FulfillmentFulfillmentLineItemApplication lineItemApplication) {
            this.lineItemApplication = Optional.ofNullable(lineItemApplication);
            return this;
        }

        @JsonSetter(value="entries", nulls=Nulls.SKIP)
        public Builder entries(Optional<List<FulfillmentFulfillmentEntry>> entries) {
            this.entries = entries;
            return this;
        }

        public Builder entries(List<FulfillmentFulfillmentEntry> entries) {
            this.entries = Optional.ofNullable(entries);
            return this;
        }

        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public Builder metadata(Optional<Map<String, Optional<String>>> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder metadata(Map<String, Optional<String>> metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        public Builder metadata(Nullable<Map<String, Optional<String>>> metadata) {
            this.metadata = metadata.isNull() ? null : (metadata.isEmpty() ? Optional.empty() : Optional.of(metadata.get()));
            return this;
        }

        @JsonSetter(value="pickup_details", nulls=Nulls.SKIP)
        public Builder pickupDetails(Optional<FulfillmentPickupDetails> pickupDetails) {
            this.pickupDetails = pickupDetails;
            return this;
        }

        public Builder pickupDetails(FulfillmentPickupDetails pickupDetails) {
            this.pickupDetails = Optional.ofNullable(pickupDetails);
            return this;
        }

        @JsonSetter(value="shipment_details", nulls=Nulls.SKIP)
        public Builder shipmentDetails(Optional<FulfillmentShipmentDetails> shipmentDetails) {
            this.shipmentDetails = shipmentDetails;
            return this;
        }

        public Builder shipmentDetails(FulfillmentShipmentDetails shipmentDetails) {
            this.shipmentDetails = Optional.ofNullable(shipmentDetails);
            return this;
        }

        @JsonSetter(value="delivery_details", nulls=Nulls.SKIP)
        public Builder deliveryDetails(Optional<FulfillmentDeliveryDetails> deliveryDetails) {
            this.deliveryDetails = deliveryDetails;
            return this;
        }

        public Builder deliveryDetails(FulfillmentDeliveryDetails deliveryDetails) {
            this.deliveryDetails = Optional.ofNullable(deliveryDetails);
            return this;
        }

        public Fulfillment build() {
            return new Fulfillment(this.uid, this.type, this.state, this.lineItemApplication, this.entries, this.metadata, this.pickupDetails, this.shipmentDetails, this.deliveryDetails, this.additionalProperties);
        }
    }
}

