/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FloatNumberRange {
    private final Optional<String> startAt;
    private final Optional<String> endAt;
    private final Map<String, Object> additionalProperties;

    private FloatNumberRange(Optional<String> startAt, Optional<String> endAt, Map<String, Object> additionalProperties) {
        this.startAt = startAt;
        this.endAt = endAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getStartAt() {
        if (this.startAt == null) {
            return Optional.empty();
        }
        return this.startAt;
    }

    @JsonIgnore
    public Optional<String> getEndAt() {
        if (this.endAt == null) {
            return Optional.empty();
        }
        return this.endAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="start_at")
    private Optional<String> _getStartAt() {
        return this.startAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="end_at")
    private Optional<String> _getEndAt() {
        return this.endAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FloatNumberRange && this.equalTo((FloatNumberRange)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FloatNumberRange other) {
        return this.startAt.equals(other.startAt) && this.endAt.equals(other.endAt);
    }

    public int hashCode() {
        return Objects.hash(this.startAt, this.endAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> startAt = Optional.empty();
        private Optional<String> endAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(FloatNumberRange other) {
            this.startAt(other.getStartAt());
            this.endAt(other.getEndAt());
            return this;
        }

        @JsonSetter(value="start_at", nulls=Nulls.SKIP)
        public Builder startAt(Optional<String> startAt) {
            this.startAt = startAt;
            return this;
        }

        public Builder startAt(String startAt) {
            this.startAt = Optional.ofNullable(startAt);
            return this;
        }

        public Builder startAt(Nullable<String> startAt) {
            this.startAt = startAt.isNull() ? null : (startAt.isEmpty() ? Optional.empty() : Optional.of(startAt.get()));
            return this;
        }

        @JsonSetter(value="end_at", nulls=Nulls.SKIP)
        public Builder endAt(Optional<String> endAt) {
            this.endAt = endAt;
            return this;
        }

        public Builder endAt(String endAt) {
            this.endAt = Optional.ofNullable(endAt);
            return this;
        }

        public Builder endAt(Nullable<String> endAt) {
            this.endAt = endAt.isNull() ? null : (endAt.isEmpty() ? Optional.empty() : Optional.of(endAt.get()));
            return this;
        }

        public FloatNumberRange build() {
            return new FloatNumberRange(this.startAt, this.endAt, this.additionalProperties);
        }
    }
}

