/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ExternalPaymentDetails {
    private final String type;
    private final String source;
    private final Optional<String> sourceId;
    private final Optional<Money> sourceFeeMoney;
    private final Map<String, Object> additionalProperties;

    private ExternalPaymentDetails(String type, String source, Optional<String> sourceId, Optional<Money> sourceFeeMoney, Map<String, Object> additionalProperties) {
        this.type = type;
        this.source = source;
        this.sourceId = sourceId;
        this.sourceFeeMoney = sourceFeeMoney;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonIgnore
    public Optional<String> getSourceId() {
        if (this.sourceId == null) {
            return Optional.empty();
        }
        return this.sourceId;
    }

    @JsonProperty(value="source_fee_money")
    public Optional<Money> getSourceFeeMoney() {
        return this.sourceFeeMoney;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="source_id")
    private Optional<String> _getSourceId() {
        return this.sourceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ExternalPaymentDetails && this.equalTo((ExternalPaymentDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExternalPaymentDetails other) {
        return this.type.equals(other.type) && this.source.equals(other.source) && this.sourceId.equals(other.sourceId) && this.sourceFeeMoney.equals(other.sourceFeeMoney);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.source, this.sourceId, this.sourceFeeMoney);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    SourceStage,
    _FinalStage {
        private String type;
        private String source;
        private Optional<Money> sourceFeeMoney = Optional.empty();
        private Optional<String> sourceId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ExternalPaymentDetails other) {
            this.type(other.getType());
            this.source(other.getSource());
            this.sourceId(other.getSourceId());
            this.sourceFeeMoney(other.getSourceFeeMoney());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public SourceStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="source")
        public _FinalStage source(@NotNull String source) {
            this.source = Objects.requireNonNull(source, "source must not be null");
            return this;
        }

        @Override
        public _FinalStage sourceFeeMoney(Money sourceFeeMoney) {
            this.sourceFeeMoney = Optional.ofNullable(sourceFeeMoney);
            return this;
        }

        @Override
        @JsonSetter(value="source_fee_money", nulls=Nulls.SKIP)
        public _FinalStage sourceFeeMoney(Optional<Money> sourceFeeMoney) {
            this.sourceFeeMoney = sourceFeeMoney;
            return this;
        }

        @Override
        public _FinalStage sourceId(Nullable<String> sourceId) {
            this.sourceId = sourceId.isNull() ? null : (sourceId.isEmpty() ? Optional.empty() : Optional.of(sourceId.get()));
            return this;
        }

        @Override
        public _FinalStage sourceId(String sourceId) {
            this.sourceId = Optional.ofNullable(sourceId);
            return this;
        }

        @Override
        @JsonSetter(value="source_id", nulls=Nulls.SKIP)
        public _FinalStage sourceId(Optional<String> sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        @Override
        public ExternalPaymentDetails build() {
            return new ExternalPaymentDetails(this.type, this.source, this.sourceId, this.sourceFeeMoney, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ExternalPaymentDetails build();

        public _FinalStage sourceId(Optional<String> var1);

        public _FinalStage sourceId(String var1);

        public _FinalStage sourceId(Nullable<String> var1);

        public _FinalStage sourceFeeMoney(Optional<Money> var1);

        public _FinalStage sourceFeeMoney(Money var1);
    }

    public static interface SourceStage {
        public _FinalStage source(@NotNull String var1);
    }

    public static interface TypeStage {
        public SourceStage type(@NotNull String var1);

        public Builder from(ExternalPaymentDetails var1);
    }
}

