/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class ExcludeStrategy {
    public static final ExcludeStrategy MOST_EXPENSIVE = new ExcludeStrategy(Value.MOST_EXPENSIVE, "MOST_EXPENSIVE");
    public static final ExcludeStrategy LEAST_EXPENSIVE = new ExcludeStrategy(Value.LEAST_EXPENSIVE, "LEAST_EXPENSIVE");
    private final Value value;
    private final String string;

    ExcludeStrategy(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ExcludeStrategy && this.string.equals(((ExcludeStrategy)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case MOST_EXPENSIVE: {
                return visitor.visitMostExpensive();
            }
            case LEAST_EXPENSIVE: {
                return visitor.visitLeastExpensive();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static ExcludeStrategy valueOf(String value) {
        switch (value) {
            case "MOST_EXPENSIVE": {
                return MOST_EXPENSIVE;
            }
            case "LEAST_EXPENSIVE": {
                return LEAST_EXPENSIVE;
            }
        }
        return new ExcludeStrategy(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitLeastExpensive();

        public T visitMostExpensive();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        LEAST_EXPENSIVE,
        MOST_EXPENSIVE,
        UNKNOWN;

    }
}

