/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class DisputeState {
    public static final DisputeState PROCESSING = new DisputeState(Value.PROCESSING, "PROCESSING");
    public static final DisputeState EVIDENCE_REQUIRED = new DisputeState(Value.EVIDENCE_REQUIRED, "EVIDENCE_REQUIRED");
    public static final DisputeState ACCEPTED = new DisputeState(Value.ACCEPTED, "ACCEPTED");
    public static final DisputeState WON = new DisputeState(Value.WON, "WON");
    public static final DisputeState LOST = new DisputeState(Value.LOST, "LOST");
    public static final DisputeState INQUIRY_CLOSED = new DisputeState(Value.INQUIRY_CLOSED, "INQUIRY_CLOSED");
    public static final DisputeState INQUIRY_EVIDENCE_REQUIRED = new DisputeState(Value.INQUIRY_EVIDENCE_REQUIRED, "INQUIRY_EVIDENCE_REQUIRED");
    public static final DisputeState INQUIRY_PROCESSING = new DisputeState(Value.INQUIRY_PROCESSING, "INQUIRY_PROCESSING");
    private final Value value;
    private final String string;

    DisputeState(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof DisputeState && this.string.equals(((DisputeState)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case PROCESSING: {
                return visitor.visitProcessing();
            }
            case EVIDENCE_REQUIRED: {
                return visitor.visitEvidenceRequired();
            }
            case ACCEPTED: {
                return visitor.visitAccepted();
            }
            case WON: {
                return visitor.visitWon();
            }
            case LOST: {
                return visitor.visitLost();
            }
            case INQUIRY_CLOSED: {
                return visitor.visitInquiryClosed();
            }
            case INQUIRY_EVIDENCE_REQUIRED: {
                return visitor.visitInquiryEvidenceRequired();
            }
            case INQUIRY_PROCESSING: {
                return visitor.visitInquiryProcessing();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static DisputeState valueOf(String value) {
        switch (value) {
            case "PROCESSING": {
                return PROCESSING;
            }
            case "EVIDENCE_REQUIRED": {
                return EVIDENCE_REQUIRED;
            }
            case "ACCEPTED": {
                return ACCEPTED;
            }
            case "WON": {
                return WON;
            }
            case "LOST": {
                return LOST;
            }
            case "INQUIRY_CLOSED": {
                return INQUIRY_CLOSED;
            }
            case "INQUIRY_EVIDENCE_REQUIRED": {
                return INQUIRY_EVIDENCE_REQUIRED;
            }
            case "INQUIRY_PROCESSING": {
                return INQUIRY_PROCESSING;
            }
        }
        return new DisputeState(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitInquiryEvidenceRequired();

        public T visitInquiryProcessing();

        public T visitInquiryClosed();

        public T visitEvidenceRequired();

        public T visitProcessing();

        public T visitWon();

        public T visitLost();

        public T visitAccepted();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        INQUIRY_EVIDENCE_REQUIRED,
        INQUIRY_PROCESSING,
        INQUIRY_CLOSED,
        EVIDENCE_REQUIRED,
        PROCESSING,
        WON,
        LOST,
        ACCEPTED,
        UNKNOWN;

    }
}

