/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DeviceStatusCategory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeviceStatus {
    private final Optional<DeviceStatusCategory> category;
    private final Map<String, Object> additionalProperties;

    private DeviceStatus(Optional<DeviceStatusCategory> category, Map<String, Object> additionalProperties) {
        this.category = category;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="category")
    public Optional<DeviceStatusCategory> getCategory() {
        return this.category;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeviceStatus && this.equalTo((DeviceStatus)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeviceStatus other) {
        return this.category.equals(other.category);
    }

    public int hashCode() {
        return Objects.hash(this.category);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<DeviceStatusCategory> category = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DeviceStatus other) {
            this.category(other.getCategory());
            return this;
        }

        @JsonSetter(value="category", nulls=Nulls.SKIP)
        public Builder category(Optional<DeviceStatusCategory> category) {
            this.category = category;
            return this;
        }

        public Builder category(DeviceStatusCategory category) {
            this.category = Optional.ofNullable(category);
            return this;
        }

        public DeviceStatus build() {
            return new DeviceStatus(this.category, this.additionalProperties);
        }
    }
}

