/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class DeviceCodeStatus {
    public static final DeviceCodeStatus PAIRED = new DeviceCodeStatus(Value.PAIRED, "PAIRED");
    public static final DeviceCodeStatus EXPIRED = new DeviceCodeStatus(Value.EXPIRED, "EXPIRED");
    public static final DeviceCodeStatus UNPAIRED = new DeviceCodeStatus(Value.UNPAIRED, "UNPAIRED");
    public static final DeviceCodeStatus UNKNOWN = new DeviceCodeStatus(Value.UNKNOWN, "UNKNOWN");
    private final Value value;
    private final String string;

    DeviceCodeStatus(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof DeviceCodeStatus && this.string.equals(((DeviceCodeStatus)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case PAIRED: {
                return visitor.visitPaired();
            }
            case EXPIRED: {
                return visitor.visitExpired();
            }
            case UNPAIRED: {
                return visitor.visitUnpaired();
            }
            case UNKNOWN: {
                return visitor.visitUnknown();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static DeviceCodeStatus valueOf(String value) {
        switch (value) {
            case "PAIRED": {
                return PAIRED;
            }
            case "EXPIRED": {
                return EXPIRED;
            }
            case "UNPAIRED": {
                return UNPAIRED;
            }
            case "UNKNOWN": {
                return UNKNOWN;
            }
        }
        return new DeviceCodeStatus(Value._UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitUnknown();

        public T visitUnpaired();

        public T visitPaired();

        public T visitExpired();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        UNKNOWN,
        UNPAIRED,
        PAIRED,
        EXPIRED,
        _UNKNOWN;

    }
}

