/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DeviceCodeStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeviceCode {
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<String> code;
    private final Optional<String> deviceId;
    private final String productType;
    private final Optional<String> locationId;
    private final Optional<DeviceCodeStatus> status;
    private final Optional<String> pairBy;
    private final Optional<String> createdAt;
    private final Optional<String> statusChangedAt;
    private final Optional<String> pairedAt;
    private final Map<String, Object> additionalProperties;

    private DeviceCode(Optional<String> id, Optional<String> name, Optional<String> code, Optional<String> deviceId, String productType, Optional<String> locationId, Optional<DeviceCodeStatus> status, Optional<String> pairBy, Optional<String> createdAt, Optional<String> statusChangedAt, Optional<String> pairedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.code = code;
        this.deviceId = deviceId;
        this.productType = productType;
        this.locationId = locationId;
        this.status = status;
        this.pairBy = pairBy;
        this.createdAt = createdAt;
        this.statusChangedAt = statusChangedAt;
        this.pairedAt = pairedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonProperty(value="code")
    public Optional<String> getCode() {
        return this.code;
    }

    @JsonProperty(value="device_id")
    public Optional<String> getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="product_type")
    public String getProductType() {
        return this.productType;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonProperty(value="status")
    public Optional<DeviceCodeStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="pair_by")
    public Optional<String> getPairBy() {
        return this.pairBy;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="status_changed_at")
    public Optional<String> getStatusChangedAt() {
        return this.statusChangedAt;
    }

    @JsonProperty(value="paired_at")
    public Optional<String> getPairedAt() {
        return this.pairedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeviceCode && this.equalTo((DeviceCode)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeviceCode other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.code.equals(other.code) && this.deviceId.equals(other.deviceId) && this.productType.equals(other.productType) && this.locationId.equals(other.locationId) && this.status.equals(other.status) && this.pairBy.equals(other.pairBy) && this.createdAt.equals(other.createdAt) && this.statusChangedAt.equals(other.statusChangedAt) && this.pairedAt.equals(other.pairedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.code, this.deviceId, this.productType, this.locationId, this.status, this.pairBy, this.createdAt, this.statusChangedAt, this.pairedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ProductTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ProductTypeStage,
    _FinalStage {
        private String productType;
        private Optional<String> pairedAt = Optional.empty();
        private Optional<String> statusChangedAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> pairBy = Optional.empty();
        private Optional<DeviceCodeStatus> status = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> deviceId = Optional.empty();
        private Optional<String> code = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DeviceCode other) {
            this.id(other.getId());
            this.name(other.getName());
            this.code(other.getCode());
            this.deviceId(other.getDeviceId());
            this.productType(other.getProductType());
            this.locationId(other.getLocationId());
            this.status(other.getStatus());
            this.pairBy(other.getPairBy());
            this.createdAt(other.getCreatedAt());
            this.statusChangedAt(other.getStatusChangedAt());
            this.pairedAt(other.getPairedAt());
            return this;
        }

        @Override
        @JsonSetter(value="product_type")
        public _FinalStage productType(@NotNull String productType) {
            this.productType = Objects.requireNonNull(productType, "productType must not be null");
            return this;
        }

        @Override
        public _FinalStage pairedAt(String pairedAt) {
            this.pairedAt = Optional.ofNullable(pairedAt);
            return this;
        }

        @Override
        @JsonSetter(value="paired_at", nulls=Nulls.SKIP)
        public _FinalStage pairedAt(Optional<String> pairedAt) {
            this.pairedAt = pairedAt;
            return this;
        }

        @Override
        public _FinalStage statusChangedAt(String statusChangedAt) {
            this.statusChangedAt = Optional.ofNullable(statusChangedAt);
            return this;
        }

        @Override
        @JsonSetter(value="status_changed_at", nulls=Nulls.SKIP)
        public _FinalStage statusChangedAt(Optional<String> statusChangedAt) {
            this.statusChangedAt = statusChangedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage pairBy(String pairBy) {
            this.pairBy = Optional.ofNullable(pairBy);
            return this;
        }

        @Override
        @JsonSetter(value="pair_by", nulls=Nulls.SKIP)
        public _FinalStage pairBy(Optional<String> pairBy) {
            this.pairBy = pairBy;
            return this;
        }

        @Override
        public _FinalStage status(DeviceCodeStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<DeviceCodeStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @Override
        public _FinalStage locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        @Override
        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public _FinalStage locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        @Override
        public _FinalStage deviceId(String deviceId) {
            this.deviceId = Optional.ofNullable(deviceId);
            return this;
        }

        @Override
        @JsonSetter(value="device_id", nulls=Nulls.SKIP)
        public _FinalStage deviceId(Optional<String> deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public _FinalStage code(String code) {
            this.code = Optional.ofNullable(code);
            return this;
        }

        @Override
        @JsonSetter(value="code", nulls=Nulls.SKIP)
        public _FinalStage code(Optional<String> code) {
            this.code = code;
            return this;
        }

        @Override
        public _FinalStage name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public DeviceCode build() {
            return new DeviceCode(this.id, this.name, this.code, this.deviceId, this.productType, this.locationId, this.status, this.pairBy, this.createdAt, this.statusChangedAt, this.pairedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DeviceCode build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage name(Nullable<String> var1);

        public _FinalStage code(Optional<String> var1);

        public _FinalStage code(String var1);

        public _FinalStage deviceId(Optional<String> var1);

        public _FinalStage deviceId(String var1);

        public _FinalStage locationId(Optional<String> var1);

        public _FinalStage locationId(String var1);

        public _FinalStage locationId(Nullable<String> var1);

        public _FinalStage status(Optional<DeviceCodeStatus> var1);

        public _FinalStage status(DeviceCodeStatus var1);

        public _FinalStage pairBy(Optional<String> var1);

        public _FinalStage pairBy(String var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage statusChangedAt(Optional<String> var1);

        public _FinalStage statusChangedAt(String var1);

        public _FinalStage pairedAt(Optional<String> var1);

        public _FinalStage pairedAt(String var1);
    }

    public static interface ProductTypeStage {
        public _FinalStage productType(@NotNull String var1);

        public Builder from(DeviceCode var1);
    }
}

