/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TipSettings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeviceCheckoutOptions {
    private final String deviceId;
    private final Optional<Boolean> skipReceiptScreen;
    private final Optional<Boolean> collectSignature;
    private final Optional<TipSettings> tipSettings;
    private final Optional<Boolean> showItemizedCart;
    private final Map<String, Object> additionalProperties;

    private DeviceCheckoutOptions(String deviceId, Optional<Boolean> skipReceiptScreen, Optional<Boolean> collectSignature, Optional<TipSettings> tipSettings, Optional<Boolean> showItemizedCart, Map<String, Object> additionalProperties) {
        this.deviceId = deviceId;
        this.skipReceiptScreen = skipReceiptScreen;
        this.collectSignature = collectSignature;
        this.tipSettings = tipSettings;
        this.showItemizedCart = showItemizedCart;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonIgnore
    public Optional<Boolean> getSkipReceiptScreen() {
        if (this.skipReceiptScreen == null) {
            return Optional.empty();
        }
        return this.skipReceiptScreen;
    }

    @JsonIgnore
    public Optional<Boolean> getCollectSignature() {
        if (this.collectSignature == null) {
            return Optional.empty();
        }
        return this.collectSignature;
    }

    @JsonProperty(value="tip_settings")
    public Optional<TipSettings> getTipSettings() {
        return this.tipSettings;
    }

    @JsonIgnore
    public Optional<Boolean> getShowItemizedCart() {
        if (this.showItemizedCart == null) {
            return Optional.empty();
        }
        return this.showItemizedCart;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="skip_receipt_screen")
    private Optional<Boolean> _getSkipReceiptScreen() {
        return this.skipReceiptScreen;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="collect_signature")
    private Optional<Boolean> _getCollectSignature() {
        return this.collectSignature;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="show_itemized_cart")
    private Optional<Boolean> _getShowItemizedCart() {
        return this.showItemizedCart;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeviceCheckoutOptions && this.equalTo((DeviceCheckoutOptions)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeviceCheckoutOptions other) {
        return this.deviceId.equals(other.deviceId) && this.skipReceiptScreen.equals(other.skipReceiptScreen) && this.collectSignature.equals(other.collectSignature) && this.tipSettings.equals(other.tipSettings) && this.showItemizedCart.equals(other.showItemizedCart);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.skipReceiptScreen, this.collectSignature, this.tipSettings, this.showItemizedCart);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeviceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DeviceIdStage,
    _FinalStage {
        private String deviceId;
        private Optional<Boolean> showItemizedCart = Optional.empty();
        private Optional<TipSettings> tipSettings = Optional.empty();
        private Optional<Boolean> collectSignature = Optional.empty();
        private Optional<Boolean> skipReceiptScreen = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DeviceCheckoutOptions other) {
            this.deviceId(other.getDeviceId());
            this.skipReceiptScreen(other.getSkipReceiptScreen());
            this.collectSignature(other.getCollectSignature());
            this.tipSettings(other.getTipSettings());
            this.showItemizedCart(other.getShowItemizedCart());
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public _FinalStage deviceId(@NotNull String deviceId) {
            this.deviceId = Objects.requireNonNull(deviceId, "deviceId must not be null");
            return this;
        }

        @Override
        public _FinalStage showItemizedCart(Nullable<Boolean> showItemizedCart) {
            this.showItemizedCart = showItemizedCart.isNull() ? null : (showItemizedCart.isEmpty() ? Optional.empty() : Optional.of(showItemizedCart.get()));
            return this;
        }

        @Override
        public _FinalStage showItemizedCart(Boolean showItemizedCart) {
            this.showItemizedCart = Optional.ofNullable(showItemizedCart);
            return this;
        }

        @Override
        @JsonSetter(value="show_itemized_cart", nulls=Nulls.SKIP)
        public _FinalStage showItemizedCart(Optional<Boolean> showItemizedCart) {
            this.showItemizedCart = showItemizedCart;
            return this;
        }

        @Override
        public _FinalStage tipSettings(TipSettings tipSettings) {
            this.tipSettings = Optional.ofNullable(tipSettings);
            return this;
        }

        @Override
        @JsonSetter(value="tip_settings", nulls=Nulls.SKIP)
        public _FinalStage tipSettings(Optional<TipSettings> tipSettings) {
            this.tipSettings = tipSettings;
            return this;
        }

        @Override
        public _FinalStage collectSignature(Nullable<Boolean> collectSignature) {
            this.collectSignature = collectSignature.isNull() ? null : (collectSignature.isEmpty() ? Optional.empty() : Optional.of(collectSignature.get()));
            return this;
        }

        @Override
        public _FinalStage collectSignature(Boolean collectSignature) {
            this.collectSignature = Optional.ofNullable(collectSignature);
            return this;
        }

        @Override
        @JsonSetter(value="collect_signature", nulls=Nulls.SKIP)
        public _FinalStage collectSignature(Optional<Boolean> collectSignature) {
            this.collectSignature = collectSignature;
            return this;
        }

        @Override
        public _FinalStage skipReceiptScreen(Nullable<Boolean> skipReceiptScreen) {
            this.skipReceiptScreen = skipReceiptScreen.isNull() ? null : (skipReceiptScreen.isEmpty() ? Optional.empty() : Optional.of(skipReceiptScreen.get()));
            return this;
        }

        @Override
        public _FinalStage skipReceiptScreen(Boolean skipReceiptScreen) {
            this.skipReceiptScreen = Optional.ofNullable(skipReceiptScreen);
            return this;
        }

        @Override
        @JsonSetter(value="skip_receipt_screen", nulls=Nulls.SKIP)
        public _FinalStage skipReceiptScreen(Optional<Boolean> skipReceiptScreen) {
            this.skipReceiptScreen = skipReceiptScreen;
            return this;
        }

        @Override
        public DeviceCheckoutOptions build() {
            return new DeviceCheckoutOptions(this.deviceId, this.skipReceiptScreen, this.collectSignature, this.tipSettings, this.showItemizedCart, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DeviceCheckoutOptions build();

        public _FinalStage skipReceiptScreen(Optional<Boolean> var1);

        public _FinalStage skipReceiptScreen(Boolean var1);

        public _FinalStage skipReceiptScreen(Nullable<Boolean> var1);

        public _FinalStage collectSignature(Optional<Boolean> var1);

        public _FinalStage collectSignature(Boolean var1);

        public _FinalStage collectSignature(Nullable<Boolean> var1);

        public _FinalStage tipSettings(Optional<TipSettings> var1);

        public _FinalStage tipSettings(TipSettings var1);

        public _FinalStage showItemizedCart(Optional<Boolean> var1);

        public _FinalStage showItemizedCart(Boolean var1);

        public _FinalStage showItemizedCart(Nullable<Boolean> var1);
    }

    public static interface DeviceIdStage {
        public _FinalStage deviceId(@NotNull String var1);

        public Builder from(DeviceCheckoutOptions var1);
    }
}

