/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Component;
import com.squareup.square.types.DeviceAttributes;
import com.squareup.square.types.DeviceStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Device {
    private final Optional<String> id;
    private final DeviceAttributes attributes;
    private final Optional<List<Component>> components;
    private final Optional<DeviceStatus> status;
    private final Map<String, Object> additionalProperties;

    private Device(Optional<String> id, DeviceAttributes attributes, Optional<List<Component>> components, Optional<DeviceStatus> status, Map<String, Object> additionalProperties) {
        this.id = id;
        this.attributes = attributes;
        this.components = components;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="attributes")
    public DeviceAttributes getAttributes() {
        return this.attributes;
    }

    @JsonIgnore
    public Optional<List<Component>> getComponents() {
        if (this.components == null) {
            return Optional.empty();
        }
        return this.components;
    }

    @JsonProperty(value="status")
    public Optional<DeviceStatus> getStatus() {
        return this.status;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="components")
    private Optional<List<Component>> _getComponents() {
        return this.components;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Device && this.equalTo((Device)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Device other) {
        return this.id.equals(other.id) && this.attributes.equals(other.attributes) && this.components.equals(other.components) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.attributes, this.components, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AttributesStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AttributesStage,
    _FinalStage {
        private DeviceAttributes attributes;
        private Optional<DeviceStatus> status = Optional.empty();
        private Optional<List<Component>> components = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Device other) {
            this.id(other.getId());
            this.attributes(other.getAttributes());
            this.components(other.getComponents());
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="attributes")
        public _FinalStage attributes(@NotNull DeviceAttributes attributes) {
            this.attributes = Objects.requireNonNull(attributes, "attributes must not be null");
            return this;
        }

        @Override
        public _FinalStage status(DeviceStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<DeviceStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage components(Nullable<List<Component>> components) {
            this.components = components.isNull() ? null : (components.isEmpty() ? Optional.empty() : Optional.of(components.get()));
            return this;
        }

        @Override
        public _FinalStage components(List<Component> components) {
            this.components = Optional.ofNullable(components);
            return this;
        }

        @Override
        @JsonSetter(value="components", nulls=Nulls.SKIP)
        public _FinalStage components(Optional<List<Component>> components) {
            this.components = components;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public Device build() {
            return new Device(this.id, this.attributes, this.components, this.status, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Device build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage components(Optional<List<Component>> var1);

        public _FinalStage components(List<Component> var1);

        public _FinalStage components(Nullable<List<Component>> var1);

        public _FinalStage status(Optional<DeviceStatus> var1);

        public _FinalStage status(DeviceStatus var1);
    }

    public static interface AttributesStage {
        public _FinalStage attributes(@NotNull DeviceAttributes var1);

        public Builder from(Device var1);
    }
}

