/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Card;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DestinationDetailsCardRefundDetails {
    private final Optional<Card> card;
    private final Optional<String> entryMethod;
    private final Optional<String> authResultCode;
    private final Map<String, Object> additionalProperties;

    private DestinationDetailsCardRefundDetails(Optional<Card> card, Optional<String> entryMethod, Optional<String> authResultCode, Map<String, Object> additionalProperties) {
        this.card = card;
        this.entryMethod = entryMethod;
        this.authResultCode = authResultCode;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="card")
    public Optional<Card> getCard() {
        return this.card;
    }

    @JsonIgnore
    public Optional<String> getEntryMethod() {
        if (this.entryMethod == null) {
            return Optional.empty();
        }
        return this.entryMethod;
    }

    @JsonIgnore
    public Optional<String> getAuthResultCode() {
        if (this.authResultCode == null) {
            return Optional.empty();
        }
        return this.authResultCode;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="entry_method")
    private Optional<String> _getEntryMethod() {
        return this.entryMethod;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="auth_result_code")
    private Optional<String> _getAuthResultCode() {
        return this.authResultCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DestinationDetailsCardRefundDetails && this.equalTo((DestinationDetailsCardRefundDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DestinationDetailsCardRefundDetails other) {
        return this.card.equals(other.card) && this.entryMethod.equals(other.entryMethod) && this.authResultCode.equals(other.authResultCode);
    }

    public int hashCode() {
        return Objects.hash(this.card, this.entryMethod, this.authResultCode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Card> card = Optional.empty();
        private Optional<String> entryMethod = Optional.empty();
        private Optional<String> authResultCode = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DestinationDetailsCardRefundDetails other) {
            this.card(other.getCard());
            this.entryMethod(other.getEntryMethod());
            this.authResultCode(other.getAuthResultCode());
            return this;
        }

        @JsonSetter(value="card", nulls=Nulls.SKIP)
        public Builder card(Optional<Card> card) {
            this.card = card;
            return this;
        }

        public Builder card(Card card) {
            this.card = Optional.ofNullable(card);
            return this;
        }

        @JsonSetter(value="entry_method", nulls=Nulls.SKIP)
        public Builder entryMethod(Optional<String> entryMethod) {
            this.entryMethod = entryMethod;
            return this;
        }

        public Builder entryMethod(String entryMethod) {
            this.entryMethod = Optional.ofNullable(entryMethod);
            return this;
        }

        public Builder entryMethod(Nullable<String> entryMethod) {
            this.entryMethod = entryMethod.isNull() ? null : (entryMethod.isEmpty() ? Optional.empty() : Optional.of(entryMethod.get()));
            return this;
        }

        @JsonSetter(value="auth_result_code", nulls=Nulls.SKIP)
        public Builder authResultCode(Optional<String> authResultCode) {
            this.authResultCode = authResultCode;
            return this;
        }

        public Builder authResultCode(String authResultCode) {
            this.authResultCode = Optional.ofNullable(authResultCode);
            return this;
        }

        public Builder authResultCode(Nullable<String> authResultCode) {
            this.authResultCode = authResultCode.isNull() ? null : (authResultCode.isEmpty() ? Optional.empty() : Optional.of(authResultCode.get()));
            return this;
        }

        public DestinationDetailsCardRefundDetails build() {
            return new DestinationDetailsCardRefundDetails(this.card, this.entryMethod, this.authResultCode, this.additionalProperties);
        }
    }
}

