/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeleteCatalogObjectResponse {
    private final Optional<List<Error>> errors;
    private final Optional<List<String>> deletedObjectIds;
    private final Optional<String> deletedAt;
    private final Map<String, Object> additionalProperties;

    private DeleteCatalogObjectResponse(Optional<List<Error>> errors, Optional<List<String>> deletedObjectIds, Optional<String> deletedAt, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.deletedObjectIds = deletedObjectIds;
        this.deletedAt = deletedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="deleted_object_ids")
    public Optional<List<String>> getDeletedObjectIds() {
        return this.deletedObjectIds;
    }

    @JsonProperty(value="deleted_at")
    public Optional<String> getDeletedAt() {
        return this.deletedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeleteCatalogObjectResponse && this.equalTo((DeleteCatalogObjectResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeleteCatalogObjectResponse other) {
        return this.errors.equals(other.errors) && this.deletedObjectIds.equals(other.deletedObjectIds) && this.deletedAt.equals(other.deletedAt);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.deletedObjectIds, this.deletedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<String>> deletedObjectIds = Optional.empty();
        private Optional<String> deletedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DeleteCatalogObjectResponse other) {
            this.errors(other.getErrors());
            this.deletedObjectIds(other.getDeletedObjectIds());
            this.deletedAt(other.getDeletedAt());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="deleted_object_ids", nulls=Nulls.SKIP)
        public Builder deletedObjectIds(Optional<List<String>> deletedObjectIds) {
            this.deletedObjectIds = deletedObjectIds;
            return this;
        }

        public Builder deletedObjectIds(List<String> deletedObjectIds) {
            this.deletedObjectIds = Optional.ofNullable(deletedObjectIds);
            return this;
        }

        @JsonSetter(value="deleted_at", nulls=Nulls.SKIP)
        public Builder deletedAt(Optional<String> deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public Builder deletedAt(String deletedAt) {
            this.deletedAt = Optional.ofNullable(deletedAt);
            return this;
        }

        public DeleteCatalogObjectResponse build() {
            return new DeleteCatalogObjectResponse(this.errors, this.deletedObjectIds, this.deletedAt, this.additionalProperties);
        }
    }
}

