/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeleteActionSubscriptionsRequest {
    private final String subscriptionId;
    private final String actionId;
    private final Map<String, Object> additionalProperties;

    private DeleteActionSubscriptionsRequest(String subscriptionId, String actionId, Map<String, Object> additionalProperties) {
        this.subscriptionId = subscriptionId;
        this.actionId = actionId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="subscription_id")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @JsonProperty(value="action_id")
    public String getActionId() {
        return this.actionId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeleteActionSubscriptionsRequest && this.equalTo((DeleteActionSubscriptionsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeleteActionSubscriptionsRequest other) {
        return this.subscriptionId.equals(other.subscriptionId) && this.actionId.equals(other.actionId);
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionId, this.actionId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SubscriptionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SubscriptionIdStage,
    ActionIdStage,
    _FinalStage {
        private String subscriptionId;
        private String actionId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DeleteActionSubscriptionsRequest other) {
            this.subscriptionId(other.getSubscriptionId());
            this.actionId(other.getActionId());
            return this;
        }

        @Override
        @JsonSetter(value="subscription_id")
        public ActionIdStage subscriptionId(@NotNull String subscriptionId) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="action_id")
        public _FinalStage actionId(@NotNull String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId must not be null");
            return this;
        }

        @Override
        public DeleteActionSubscriptionsRequest build() {
            return new DeleteActionSubscriptionsRequest(this.subscriptionId, this.actionId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DeleteActionSubscriptionsRequest build();
    }

    public static interface ActionIdStage {
        public _FinalStage actionId(@NotNull String var1);
    }

    public static interface SubscriptionIdStage {
        public ActionIdStage subscriptionId(@NotNull String var1);

        public Builder from(DeleteActionSubscriptionsRequest var1);
    }
}

