/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DateRange {
    private final Optional<String> startDate;
    private final Optional<String> endDate;
    private final Map<String, Object> additionalProperties;

    private DateRange(Optional<String> startDate, Optional<String> endDate, Map<String, Object> additionalProperties) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getStartDate() {
        if (this.startDate == null) {
            return Optional.empty();
        }
        return this.startDate;
    }

    @JsonIgnore
    public Optional<String> getEndDate() {
        if (this.endDate == null) {
            return Optional.empty();
        }
        return this.endDate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="start_date")
    private Optional<String> _getStartDate() {
        return this.startDate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="end_date")
    private Optional<String> _getEndDate() {
        return this.endDate;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DateRange && this.equalTo((DateRange)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DateRange other) {
        return this.startDate.equals(other.startDate) && this.endDate.equals(other.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> startDate = Optional.empty();
        private Optional<String> endDate = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DateRange other) {
            this.startDate(other.getStartDate());
            this.endDate(other.getEndDate());
            return this;
        }

        @JsonSetter(value="start_date", nulls=Nulls.SKIP)
        public Builder startDate(Optional<String> startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder startDate(String startDate) {
            this.startDate = Optional.ofNullable(startDate);
            return this;
        }

        public Builder startDate(Nullable<String> startDate) {
            this.startDate = startDate.isNull() ? null : (startDate.isEmpty() ? Optional.empty() : Optional.of(startDate.get()));
            return this;
        }

        @JsonSetter(value="end_date", nulls=Nulls.SKIP)
        public Builder endDate(Optional<String> endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder endDate(String endDate) {
            this.endDate = Optional.ofNullable(endDate);
            return this;
        }

        public Builder endDate(Nullable<String> endDate) {
            this.endDate = endDate.isNull() ? null : (endDate.isEmpty() ? Optional.empty() : Optional.of(endDate.get()));
            return this;
        }

        public DateRange build() {
            return new DateRange(this.startDate, this.endDate, this.additionalProperties);
        }
    }
}

