/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomerTextFilter {
    private final Optional<String> exact;
    private final Optional<String> fuzzy;
    private final Map<String, Object> additionalProperties;

    private CustomerTextFilter(Optional<String> exact, Optional<String> fuzzy, Map<String, Object> additionalProperties) {
        this.exact = exact;
        this.fuzzy = fuzzy;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getExact() {
        if (this.exact == null) {
            return Optional.empty();
        }
        return this.exact;
    }

    @JsonIgnore
    public Optional<String> getFuzzy() {
        if (this.fuzzy == null) {
            return Optional.empty();
        }
        return this.fuzzy;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="exact")
    private Optional<String> _getExact() {
        return this.exact;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="fuzzy")
    private Optional<String> _getFuzzy() {
        return this.fuzzy;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomerTextFilter && this.equalTo((CustomerTextFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomerTextFilter other) {
        return this.exact.equals(other.exact) && this.fuzzy.equals(other.fuzzy);
    }

    public int hashCode() {
        return Objects.hash(this.exact, this.fuzzy);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> exact = Optional.empty();
        private Optional<String> fuzzy = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomerTextFilter other) {
            this.exact(other.getExact());
            this.fuzzy(other.getFuzzy());
            return this;
        }

        @JsonSetter(value="exact", nulls=Nulls.SKIP)
        public Builder exact(Optional<String> exact) {
            this.exact = exact;
            return this;
        }

        public Builder exact(String exact) {
            this.exact = Optional.ofNullable(exact);
            return this;
        }

        public Builder exact(Nullable<String> exact) {
            this.exact = exact.isNull() ? null : (exact.isEmpty() ? Optional.empty() : Optional.of(exact.get()));
            return this;
        }

        @JsonSetter(value="fuzzy", nulls=Nulls.SKIP)
        public Builder fuzzy(Optional<String> fuzzy) {
            this.fuzzy = fuzzy;
            return this;
        }

        public Builder fuzzy(String fuzzy) {
            this.fuzzy = Optional.ofNullable(fuzzy);
            return this;
        }

        public Builder fuzzy(Nullable<String> fuzzy) {
            this.fuzzy = fuzzy.isNull() ? null : (fuzzy.isEmpty() ? Optional.empty() : Optional.of(fuzzy.get()));
            return this;
        }

        public CustomerTextFilter build() {
            return new CustomerTextFilter(this.exact, this.fuzzy, this.additionalProperties);
        }
    }
}

