/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomerCustomAttributeFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomerCustomAttributeFilters {
    private final Optional<List<CustomerCustomAttributeFilter>> filters;
    private final Map<String, Object> additionalProperties;

    private CustomerCustomAttributeFilters(Optional<List<CustomerCustomAttributeFilter>> filters, Map<String, Object> additionalProperties) {
        this.filters = filters;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<CustomerCustomAttributeFilter>> getFilters() {
        if (this.filters == null) {
            return Optional.empty();
        }
        return this.filters;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filters")
    private Optional<List<CustomerCustomAttributeFilter>> _getFilters() {
        return this.filters;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomerCustomAttributeFilters && this.equalTo((CustomerCustomAttributeFilters)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomerCustomAttributeFilters other) {
        return this.filters.equals(other.filters);
    }

    public int hashCode() {
        return Objects.hash(this.filters);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<CustomerCustomAttributeFilter>> filters = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomerCustomAttributeFilters other) {
            this.filters(other.getFilters());
            return this;
        }

        @JsonSetter(value="filters", nulls=Nulls.SKIP)
        public Builder filters(Optional<List<CustomerCustomAttributeFilter>> filters) {
            this.filters = filters;
            return this;
        }

        public Builder filters(List<CustomerCustomAttributeFilter> filters) {
            this.filters = Optional.ofNullable(filters);
            return this;
        }

        public Builder filters(Nullable<List<CustomerCustomAttributeFilter>> filters) {
            this.filters = filters.isNull() ? null : (filters.isEmpty() ? Optional.empty() : Optional.of(filters.get()));
            return this;
        }

        public CustomerCustomAttributeFilters build() {
            return new CustomerCustomAttributeFilters(this.filters, this.additionalProperties);
        }
    }
}

