/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomerCustomAttributeFilterValue;
import com.squareup.square.types.TimeRange;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomerCustomAttributeFilter {
    private final String key;
    private final Optional<CustomerCustomAttributeFilterValue> filter;
    private final Optional<TimeRange> updatedAt;
    private final Map<String, Object> additionalProperties;

    private CustomerCustomAttributeFilter(String key, Optional<CustomerCustomAttributeFilterValue> filter, Optional<TimeRange> updatedAt, Map<String, Object> additionalProperties) {
        this.key = key;
        this.filter = filter;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="filter")
    public Optional<CustomerCustomAttributeFilterValue> getFilter() {
        return this.filter;
    }

    @JsonProperty(value="updated_at")
    public Optional<TimeRange> getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomerCustomAttributeFilter && this.equalTo((CustomerCustomAttributeFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomerCustomAttributeFilter other) {
        return this.key.equals(other.key) && this.filter.equals(other.filter) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.filter, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static KeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements KeyStage,
    _FinalStage {
        private String key;
        private Optional<TimeRange> updatedAt = Optional.empty();
        private Optional<CustomerCustomAttributeFilterValue> filter = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CustomerCustomAttributeFilter other) {
            this.key(other.getKey());
            this.filter(other.getFilter());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="key")
        public _FinalStage key(@NotNull String key) {
            this.key = Objects.requireNonNull(key, "key must not be null");
            return this;
        }

        @Override
        public _FinalStage updatedAt(TimeRange updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<TimeRange> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage filter(CustomerCustomAttributeFilterValue filter) {
            this.filter = Optional.ofNullable(filter);
            return this;
        }

        @Override
        @JsonSetter(value="filter", nulls=Nulls.SKIP)
        public _FinalStage filter(Optional<CustomerCustomAttributeFilterValue> filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public CustomerCustomAttributeFilter build() {
            return new CustomerCustomAttributeFilter(this.key, this.filter, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CustomerCustomAttributeFilter build();

        public _FinalStage filter(Optional<CustomerCustomAttributeFilterValue> var1);

        public _FinalStage filter(CustomerCustomAttributeFilterValue var1);

        public _FinalStage updatedAt(Optional<TimeRange> var1);

        public _FinalStage updatedAt(TimeRange var1);
    }

    public static interface KeyStage {
        public _FinalStage key(@NotNull String var1);

        public Builder from(CustomerCustomAttributeFilter var1);
    }
}

