/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomerCreationSource;
import com.squareup.square.types.CustomerInclusionExclusion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomerCreationSourceFilter {
    private final Optional<List<CustomerCreationSource>> values;
    private final Optional<CustomerInclusionExclusion> rule;
    private final Map<String, Object> additionalProperties;

    private CustomerCreationSourceFilter(Optional<List<CustomerCreationSource>> values, Optional<CustomerInclusionExclusion> rule, Map<String, Object> additionalProperties) {
        this.values = values;
        this.rule = rule;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<CustomerCreationSource>> getValues() {
        if (this.values == null) {
            return Optional.empty();
        }
        return this.values;
    }

    @JsonProperty(value="rule")
    public Optional<CustomerInclusionExclusion> getRule() {
        return this.rule;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="values")
    private Optional<List<CustomerCreationSource>> _getValues() {
        return this.values;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomerCreationSourceFilter && this.equalTo((CustomerCreationSourceFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomerCreationSourceFilter other) {
        return this.values.equals(other.values) && this.rule.equals(other.rule);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.rule);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<CustomerCreationSource>> values = Optional.empty();
        private Optional<CustomerInclusionExclusion> rule = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomerCreationSourceFilter other) {
            this.values(other.getValues());
            this.rule(other.getRule());
            return this;
        }

        @JsonSetter(value="values", nulls=Nulls.SKIP)
        public Builder values(Optional<List<CustomerCreationSource>> values) {
            this.values = values;
            return this;
        }

        public Builder values(List<CustomerCreationSource> values) {
            this.values = Optional.ofNullable(values);
            return this;
        }

        public Builder values(Nullable<List<CustomerCreationSource>> values) {
            this.values = values.isNull() ? null : (values.isEmpty() ? Optional.empty() : Optional.of(values.get()));
            return this;
        }

        @JsonSetter(value="rule", nulls=Nulls.SKIP)
        public Builder rule(Optional<CustomerInclusionExclusion> rule) {
            this.rule = rule;
            return this;
        }

        public Builder rule(CustomerInclusionExclusion rule) {
            this.rule = Optional.ofNullable(rule);
            return this;
        }

        public CustomerCreationSourceFilter build() {
            return new CustomerCreationSourceFilter(this.values, this.rule, this.additionalProperties);
        }
    }
}

